/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.CheckedFunction1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Recoverable;

@FunctionalInterface
public interface CheckedProducer<T>
extends Recoverable {
    public T get() throws Exception;

    default public <V> CheckedFunction1<V, T> asFunction() {
        return value -> this.get();
    }

    default public <R> CheckedProducer<R> andThen(CheckedFunction1<T, R> after) {
        return () -> after.apply(this.get());
    }

    default public Producer<T> recover(Function1<Throwable, T> mapper) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                return mapper.apply(e);
            }
        };
    }

    default public Producer<T> unchecked() {
        return this.recover(this::sneakyThrow);
    }

    public static <T> CheckedProducer<T> unit(T value) {
        return () -> value;
    }

    public static <T, X extends Exception> CheckedProducer<T> failure(Producer<X> supplier) {
        return () -> {
            throw (Exception)supplier.get();
        };
    }

    public static <T> CheckedProducer<T> of(CheckedProducer<T> reference) {
        return reference;
    }
}

