/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.CheckedProducer;
import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Recoverable;

@FunctionalInterface
public interface CheckedRunnable
extends Recoverable {
    public void run() throws Exception;

    default public CheckedProducer<Nothing> asProducer() {
        return () -> {
            this.run();
            return Nothing.nothing();
        };
    }

    default public Runnable recover(Consumer1<Throwable> mapper) {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                mapper.accept(e);
            }
        };
    }

    default public Runnable unchecked() {
        return this.recover(this::sneakyThrow);
    }

    public static <X extends Exception> CheckedRunnable failure(Producer<X> supplier) {
        return () -> {
            throw (Exception)supplier.get();
        };
    }

    public static CheckedRunnable of(CheckedRunnable runnable) {
        return runnable;
    }
}

