/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.CheckedFunction1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.handler.EitherHandler;
import com.github.tonivade.purefun.handler.OptionHandler;
import com.github.tonivade.purefun.handler.OptionalHandler;
import com.github.tonivade.purefun.handler.SequenceHandler;
import com.github.tonivade.purefun.handler.StreamHandler;
import com.github.tonivade.purefun.handler.TryHandler;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import java.util.Optional;
import java.util.stream.Stream;

@FunctionalInterface
public interface Function1<T, R> {
    public R apply(T var1);

    default public <V> Function1<T, V> andThen(Function1<R, V> after) {
        return value -> after.apply(this.apply(value));
    }

    default public <V> Function1<V, R> compose(Function1<V, T> before) {
        return value -> this.apply(before.apply(value));
    }

    default public OptionalHandler<T, R> liftOptional() {
        return value -> Optional.ofNullable(this.apply(value));
    }

    default public OptionHandler<T, R> liftOption() {
        return value -> Option.of(() -> this.apply(value));
    }

    default public TryHandler<T, R> liftTry() {
        return value -> Try.of(() -> this.apply(value));
    }

    default public EitherHandler<T, Throwable, R> liftEither() {
        return this.liftTry().toEither();
    }

    default public <L> EitherHandler<T, L, R> liftRight() {
        return value -> Either.right(this.apply(value));
    }

    default public <L> EitherHandler<T, R, L> liftLeft() {
        return value -> Either.left(this.apply(value));
    }

    default public SequenceHandler<T, R> sequence() {
        return value -> Sequence.listOf(this.apply(value));
    }

    default public StreamHandler<T, R> stream() {
        return value -> Stream.of(this.apply(value));
    }

    default public CheckedFunction1<T, R> checked() {
        return this::apply;
    }

    public static <T> Function1<T, T> identity() {
        return value -> value;
    }

    public static <T, R> Function1<T, R> of(Function1<T, R> reference) {
        return reference;
    }
}

