/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Tuple2;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;

@FunctionalInterface
public interface Function2<T, V, R> {
    public R apply(T var1, V var2);

    default public Function1<T, Function1<V, R>> curried() {
        return t -> v -> this.apply(t, v);
    }

    default public Function1<Tuple2<T, V>, R> tupled() {
        return tuple -> this.apply(tuple.get1(), tuple.get2());
    }

    default public <U> Function2<T, V, U> andThen(Function1<R, U> after) {
        return (t, v) -> after.apply(this.apply(t, v));
    }

    default public <U> Function1<U, R> compose(Function1<U, T> beforeT, Function1<U, V> beforeV) {
        return value -> this.apply(beforeT.apply(value), beforeV.apply(value));
    }

    default public Function2<T, V, Try<R>> liftTry() {
        return (t, v) -> Try.of(() -> this.apply(t, v));
    }

    default public Function2<T, V, Either<Throwable, R>> liftEither() {
        return this.liftTry().andThen(Try::toEither);
    }

    default public Function2<T, V, Option<R>> liftOption() {
        return this.liftTry().andThen(Try::toOption);
    }

    public static <T, V, R> Function2<T, V, R> of(Function2<T, V, R> reference) {
        return reference;
    }
}

