/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import java.util.Objects;
import java.util.stream.Stream;

@FunctionalInterface
public interface Matcher1<T> {
    public boolean match(T var1);

    default public Matcher1<T> and(Matcher1<T> other) {
        return value -> this.match(value) && other.match(value);
    }

    default public Matcher1<T> or(Matcher1<T> other) {
        return value -> this.match(value) || other.match(value);
    }

    default public Matcher1<T> negate() {
        return value -> !this.match(value);
    }

    public static <T> Matcher1<T> not(Matcher1<T> matcher) {
        return matcher.negate();
    }

    public static <T> Matcher1<T> instanceOf(Class<?> type) {
        Objects.requireNonNull(type);
        return value -> Objects.nonNull(value) && type.isAssignableFrom(value.getClass());
    }

    public static <T> Matcher1<T> is(T other) {
        Objects.requireNonNull(other);
        return value -> Objects.equals(value, other);
    }

    @SafeVarargs
    public static <T> Matcher1<T> isIn(T ... values) {
        Objects.requireNonNull(values);
        return target -> Stream.of(values).anyMatch(value -> Objects.equals(target, value));
    }

    public static <T> Matcher1<T> isNull() {
        return Objects::isNull;
    }

    public static <T> Matcher1<T> isNotNull() {
        return Objects::nonNull;
    }

    @SafeVarargs
    public static <T> Matcher1<T> allOf(Matcher1<T> ... matchers) {
        Objects.requireNonNull(matchers);
        return target -> Stream.of(matchers).allMatch(matcher -> matcher.match(target));
    }

    @SafeVarargs
    public static <T> Matcher1<T> anyOf(Matcher1<T> ... matchers) {
        Objects.requireNonNull(matchers);
        return target -> Stream.of(matchers).anyMatch(matcher -> matcher.match(target));
    }

    public static <T> Matcher1<T> otherwise() {
        return value -> true;
    }
}

