/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.type.Option;
import java.util.Objects;

public final class Pattern1<T, R>
implements Function1<T, R> {
    private final ImmutableList<Case<T, R>> cases;

    private Pattern1() {
        this(ImmutableList.empty());
    }

    private Pattern1(ImmutableList<Case<T, R>> cases) {
        this.cases = Objects.requireNonNull(cases);
    }

    public static <T, R> Pattern1<T, R> build() {
        return new Pattern1<T, R>();
    }

    public CaseBuilder1<Pattern1<T, R>, T, R> when(Matcher1<T> matcher) {
        return new CaseBuilder1(this::add).when(matcher);
    }

    public CaseBuilder1<Pattern1<T, R>, T, R> otherwise() {
        return new CaseBuilder1(this::add).when(Matcher1.otherwise());
    }

    @Override
    public R apply(T target) {
        return (R)this.findCase(target).map(case_ -> case_.apply(target)).orElseThrow(IllegalStateException::new);
    }

    protected Pattern1<T, R> add(Matcher1<T> matcher, Function1<T, R> handler) {
        return new Pattern1<T, R>(this.cases.append((Object)new Case<T, R>(matcher, handler)));
    }

    private Option<Case<T, R>> findCase(T target) {
        return this.cases.filter(case_ -> case_.match(target)).head();
    }

    public static final class CaseBuilder1<B, T, R> {
        private final Function2<Matcher1<T>, Function1<T, R>, B> finisher;
        private final Matcher1<T> matcher;

        private CaseBuilder1(Function2<Matcher1<T>, Function1<T, R>, B> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
            this.matcher = null;
        }

        private CaseBuilder1(Function2<Matcher1<T>, Function1<T, R>, B> finisher, Matcher1<T> matcher) {
            this.finisher = Objects.requireNonNull(finisher);
            this.matcher = Objects.requireNonNull(matcher);
        }

        public CaseBuilder1<B, T, R> when(Matcher1<T> matcher) {
            return new CaseBuilder1<B, T, R>(this.finisher, matcher);
        }

        public B then(Function1<T, R> handler) {
            return this.finisher.apply(this.matcher, handler);
        }

        public B returns(R value) {
            return this.then(target -> value);
        }
    }

    public static final class Case<T, R> {
        private final Matcher1<T> matcher;
        private final Function1<T, R> handler;

        Case(Matcher1<T> matcher, Function1<T, R> handler) {
            this.matcher = Objects.requireNonNull(matcher);
            this.handler = Objects.requireNonNull(handler);
        }

        public boolean match(T value) {
            return this.matcher.match(value);
        }

        public R apply(T value) {
            return this.handler.apply(value);
        }
    }
}

