/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Matcher2;
import com.github.tonivade.purefun.Pattern1;
import com.github.tonivade.purefun.Tuple;
import com.github.tonivade.purefun.Tuple2;
import java.util.Objects;

public class Pattern2<A, B, R>
implements Function2<A, B, R> {
    private final Pattern1<Tuple2<A, B>, R> pattern;

    private Pattern2() {
        this(Pattern1.build());
    }

    private Pattern2(Pattern1<Tuple2<A, B>, R> pattern) {
        this.pattern = Objects.requireNonNull(pattern);
    }

    @Override
    public R apply(A a, B b) {
        return this.pattern.apply(Tuple.of(a, b));
    }

    public static <A, B, R> Pattern2<A, B, R> build() {
        return new Pattern2<A, B, R>();
    }

    public CaseBuilder2<Pattern2<A, B, R>, A, B, R> when(Matcher2<A, B> matcher) {
        return new CaseBuilder2(this::add).when(matcher);
    }

    public CaseBuilder2<Pattern2<A, B, R>, A, B, R> otherwise() {
        return new CaseBuilder2(this::add).when(Matcher2.otherwise());
    }

    private Pattern2<A, B, R> add(Matcher2<A, B> matcher, Function2<A, B, R> handler) {
        return new Pattern2<A, B, R>(this.pattern.add(matcher.tupled(), handler.tupled()));
    }

    public static final class CaseBuilder2<B, T, V, R> {
        private final Function2<Matcher2<T, V>, Function2<T, V, R>, B> finisher;
        private final Matcher2<T, V> matcher;

        private CaseBuilder2(Function2<Matcher2<T, V>, Function2<T, V, R>, B> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
            this.matcher = null;
        }

        private CaseBuilder2(Function2<Matcher2<T, V>, Function2<T, V, R>, B> finisher, Matcher2<T, V> matcher) {
            this.finisher = Objects.requireNonNull(finisher);
            this.matcher = Objects.requireNonNull(matcher);
        }

        public CaseBuilder2<B, T, V, R> when(Matcher2<T, V> matcher) {
            return new CaseBuilder2<B, T, V, R>(this.finisher, matcher);
        }

        public B then(Function2<T, V, R> handler) {
            return this.finisher.apply(this.matcher, handler);
        }

        public B returns(R value) {
            return this.then((a, b) -> value);
        }
    }
}

