/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;

@FunctionalInterface
public interface Producer<T> {
    public T get();

    default public <V> Function1<V, T> asFunction() {
        return value -> this.get();
    }

    default public <R> Producer<R> andThen(Function1<T, R> after) {
        return () -> after.apply(this.get());
    }

    default public Producer<Option<T>> liftOption() {
        return () -> Option.of(this::get);
    }

    default public Producer<Try<T>> liftTry() {
        return () -> Try.of(this::get);
    }

    default public Producer<Either<Throwable, T>> liftEither() {
        return this.liftTry().andThen(Try::toEither);
    }

    public static <T> Producer<T> unit(T value) {
        return () -> value;
    }

    public static <T> Producer<T> of(Producer<T> reference) {
        return reference;
    }
}

