/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Tuple;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Objects;

public final class Tuple2<A, B>
implements Tuple,
Serializable {
    private static final long serialVersionUID = 5034828839532504174L;
    private final A value1;
    private final B value2;

    private Tuple2(A value1, B value2) {
        this.value1 = Objects.requireNonNull(value1);
        this.value2 = Objects.requireNonNull(value2);
    }

    public A get1() {
        return this.value1;
    }

    public B get2() {
        return this.value2;
    }

    @Override
    public Sequence<Object> toSequence() {
        return Sequence.listOf(this.value1, this.value2);
    }

    public <C> Tuple2<C, B> map1(Function1<A, C> mapper) {
        return this.map(mapper, Function1.identity());
    }

    public <C> Tuple2<A, C> map2(Function1<B, C> mapper) {
        return this.map(Function1.identity(), mapper);
    }

    public <C, D> Tuple2<C, D> map(Function1<A, C> mapper1, Function1<B, D> mapper2) {
        return Tuple2.of(mapper1.apply(this.value1), mapper2.apply(this.value2));
    }

    public static <A, B> Tuple2<A, B> of(A value1, B value2) {
        return new Tuple2<A, B>(value1, value2);
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2);
    }

    public boolean equals(Object obj) {
        return Equal.of(this).append(Equal.comparing(Tuple2::get1)).append(Equal.comparing(Tuple2::get2)).applyTo(obj);
    }

    public String toString() {
        return "Tuple2(" + this.value1 + ", " + this.value2 + ")";
    }
}

