/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Tuple;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Objects;

public final class Tuple3<A, B, C>
implements Tuple,
Serializable {
    private static final long serialVersionUID = -4316365232845710129L;
    private final A value1;
    private final B value2;
    private final C value3;

    private Tuple3(A value1, B value2, C value3) {
        this.value1 = Objects.requireNonNull(value1);
        this.value2 = Objects.requireNonNull(value2);
        this.value3 = Objects.requireNonNull(value3);
    }

    public A get1() {
        return this.value1;
    }

    public B get2() {
        return this.value2;
    }

    public C get3() {
        return this.value3;
    }

    @Override
    public Sequence<Object> toSequence() {
        return Sequence.listOf(this.value1, this.value2, this.value3);
    }

    public <R> Tuple3<R, B, C> map1(Function1<A, R> mapper) {
        return Tuple3.of(mapper.apply(this.value1), this.value2, this.value3);
    }

    public <R> Tuple3<A, R, C> map2(Function1<B, R> mapper) {
        return Tuple3.of(this.value1, mapper.apply(this.value2), this.value3);
    }

    public <R> Tuple3<A, B, R> map3(Function1<C, R> mapper) {
        return Tuple3.of(this.value1, this.value2, mapper.apply(this.value3));
    }

    public <D, E, F> Tuple3<D, E, F> map(Function1<A, D> map1, Function1<B, E> map2, Function1<C, F> map3) {
        return Tuple3.of(map1.apply(this.value1), map2.apply(this.value2), map3.apply(this.value3));
    }

    public static <A, B, C> Tuple3<A, B, C> of(A value1, B value2, C value3) {
        return new Tuple3<A, B, C>(value1, value2, value3);
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2, this.value3);
    }

    public boolean equals(Object obj) {
        return Equal.of(this).append(Equal.comparing(Tuple3::get1)).append(Equal.comparing(Tuple3::get2)).append(Equal.comparing(Tuple3::get3)).applyTo(obj);
    }

    public String toString() {
        return "Tuple3(" + this.value1 + ", " + this.value2 + ", " + this.value3 + ")";
    }
}

