/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Tuple;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Objects;

public final class Tuple4<A, B, C, D>
implements Tuple,
Serializable {
    private static final long serialVersionUID = -2725249702715042810L;
    private final A value1;
    private final B value2;
    private final C value3;
    private final D value4;

    private Tuple4(A value1, B value2, C value3, D value4) {
        this.value1 = Objects.requireNonNull(value1);
        this.value2 = Objects.requireNonNull(value2);
        this.value3 = Objects.requireNonNull(value3);
        this.value4 = Objects.requireNonNull(value4);
    }

    public A get1() {
        return this.value1;
    }

    public B get2() {
        return this.value2;
    }

    public C get3() {
        return this.value3;
    }

    public D get4() {
        return this.value4;
    }

    @Override
    public Sequence<Object> toSequence() {
        return Sequence.listOf(this.value1, this.value2, this.value3, this.value4);
    }

    public <R> Tuple4<R, B, C, D> map1(Function1<A, R> mapper) {
        return Tuple4.of(mapper.apply(this.value1), this.value2, this.value3, this.value4);
    }

    public <R> Tuple4<A, R, C, D> map2(Function1<B, R> mapper) {
        return Tuple4.of(this.value1, mapper.apply(this.value2), this.value3, this.value4);
    }

    public <R> Tuple4<A, B, R, D> map3(Function1<C, R> mapper) {
        return Tuple4.of(this.value1, this.value2, mapper.apply(this.value3), this.value4);
    }

    public <R> Tuple4<A, B, C, R> map4(Function1<D, R> mapper) {
        return Tuple4.of(this.value1, this.value2, this.value3, mapper.apply(this.value4));
    }

    public <E, F, G, H> Tuple4<E, F, G, H> map(Function1<A, E> map1, Function1<B, F> map2, Function1<C, G> map3, Function1<D, H> map4) {
        return Tuple4.of(map1.apply(this.value1), map2.apply(this.value2), map3.apply(this.value3), map4.apply(this.value4));
    }

    public static <A, B, C, D> Tuple4<A, B, C, D> of(A value1, B value2, C value3, D value4) {
        return new Tuple4<A, B, C, D>(value1, value2, value3, value4);
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2, this.value3, this.value4);
    }

    public boolean equals(Object obj) {
        return Equal.of(this).append(Equal.comparing(Tuple4::get1)).append(Equal.comparing(Tuple4::get2)).append(Equal.comparing(Tuple4::get3)).append(Equal.comparing(Tuple4::get4)).applyTo(obj);
    }

    public String toString() {
        return "Tuple4(" + this.value1 + ", " + this.value2 + ", " + this.value3 + ", " + this.value4 + ")";
    }
}

