/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ImmutableArray<E>
extends Sequence<E> {
    public List<E> toList();

    @Override
    public ImmutableArray<E> append(E var1);

    @Override
    public ImmutableArray<E> remove(E var1);

    @Override
    public ImmutableArray<E> appendAll(Sequence<E> var1);

    @Override
    public ImmutableArray<E> removeAll(Sequence<E> var1);

    @Override
    public ImmutableArray<E> reverse();

    public ImmutableArray<E> sort(Comparator<E> var1);

    public E get(int var1);

    @Override
    public ImmutableArray<E> remove(int var1);

    public ImmutableArray<E> replace(int var1, E var2);

    public ImmutableArray<E> insert(int var1, E var2);

    public ImmutableArray<E> insertAll(int var1, Sequence<E> var2);

    default public ImmutableArray<E> drop(int n) {
        return ImmutableArray.from(this.stream().skip(n));
    }

    @Override
    default public <R> ImmutableArray<R> map(Function1<E, R> mapper) {
        return ImmutableArray.from(this.stream().map(mapper::apply));
    }

    @Override
    default public <R> ImmutableArray<R> flatMap(Function1<E, ? extends Higher1<Sequence.\u00b5, R>> mapper) {
        return ImmutableArray.from(this.stream().flatMap((? super T element) -> Sequence.narrowK((Higher1)mapper.apply(element)).stream()));
    }

    @Override
    default public ImmutableArray<E> filter(Matcher1<E> matcher) {
        return ImmutableArray.from(this.stream().filter(matcher::match));
    }

    public static <T> ImmutableArray<T> from(Iterable<T> iterable) {
        return ImmutableArray.from(Sequence.asStream(iterable.iterator()));
    }

    public static <T> ImmutableArray<T> from(Stream<T> stream) {
        return new JavaBasedImmutableArray(stream.collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> ImmutableArray<T> of(T ... elements) {
        return new JavaBasedImmutableArray(Arrays.asList(elements));
    }

    public static <T> ImmutableArray<T> empty() {
        return new JavaBasedImmutableArray(Collections.emptyList());
    }

    public static final class JavaBasedImmutableArray<E>
    implements ImmutableArray<E>,
    Serializable {
        private static final long serialVersionUID = 5728385935547829871L;
        private final List<E> backend;

        private JavaBasedImmutableArray(List<E> backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean contains(E element) {
            return this.backend.contains(element);
        }

        @Override
        public ImmutableArray<E> reverse() {
            List<E> list = this.toList();
            Collections.reverse(list);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public Iterator<E> iterator() {
            return this.backend.iterator();
        }

        @Override
        public ImmutableArray<E> append(E element) {
            List<E> list = this.toList();
            list.add(element);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> remove(E element) {
            List<E> list = this.toList();
            list.remove(element);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> appendAll(Sequence<E> other) {
            List list = this.toList();
            for (Object element : other) {
                list.add(element);
            }
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> removeAll(Sequence<E> other) {
            List<E> list = this.toList();
            for (Object element : other) {
                list.remove(element);
            }
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> sort(Comparator<E> comparator) {
            List<E> list = this.toList();
            Collections.sort(list, comparator);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public E get(int position) {
            return this.backend.get(position);
        }

        @Override
        public ImmutableArray<E> replace(int position, E element) {
            List<E> list = this.toList();
            list.set(position, element);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> remove(int position) {
            List<E> list = this.toList();
            list.remove(position);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> insert(int position, E element) {
            List<E> list = this.toList();
            list.add(position, element);
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public ImmutableArray<E> insertAll(int position, Sequence<E> elements) {
            List<E> list = this.toList();
            list.addAll(position, elements.stream().collect(Collectors.toList()));
            return new JavaBasedImmutableArray<E>(list);
        }

        @Override
        public List<E> toList() {
            return new ArrayList<E>(this.backend);
        }

        public int hashCode() {
            return Objects.hash(this.backend);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append((a, b) -> Objects.equals(a.backend, b.backend)).applyTo(obj);
        }

        public String toString() {
            return "ImmutableArray(" + this.backend + ")";
        }
    }
}

