/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ImmutableList<E>
extends Sequence<E> {
    public List<E> toList();

    @Override
    public ImmutableList<E> append(E var1);

    @Override
    public ImmutableList<E> remove(E var1);

    @Override
    public ImmutableList<E> appendAll(Sequence<E> var1);

    @Override
    public ImmutableList<E> removeAll(Sequence<E> var1);

    @Override
    public ImmutableList<E> reverse();

    public ImmutableList<E> sort(Comparator<E> var1);

    default public Option<E> head() {
        return Option.from(this.stream().findFirst());
    }

    default public ImmutableList<E> tail() {
        return this.drop(1);
    }

    default public ImmutableList<E> drop(int n) {
        return ImmutableList.from(this.stream().skip(n));
    }

    @Override
    default public <R> ImmutableList<R> map(Function1<E, R> mapper) {
        return ImmutableList.from(this.stream().map(mapper::apply));
    }

    @Override
    default public <R> ImmutableList<R> flatMap(Function1<E, ? extends Higher1<Sequence.\u00b5, R>> mapper) {
        return ImmutableList.from(this.stream().flatMap((? super T element) -> Sequence.narrowK((Higher1)mapper.apply(element)).stream()));
    }

    @Override
    default public ImmutableList<E> filter(Matcher1<E> matcher) {
        return ImmutableList.from(this.stream().filter(matcher::match));
    }

    public static <T> ImmutableList<T> from(Iterable<T> iterable) {
        return ImmutableList.from(Sequence.asStream(iterable.iterator()));
    }

    public static <T> ImmutableList<T> from(Stream<T> stream) {
        return new JavaBasedImmutableList(stream.collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T> ImmutableList<T> of(T ... elements) {
        return new JavaBasedImmutableList(Arrays.asList(elements));
    }

    public static <T> ImmutableList<T> empty() {
        return new JavaBasedImmutableList(Collections.emptyList());
    }

    public static final class JavaBasedImmutableList<E>
    implements ImmutableList<E>,
    Serializable {
        private static final long serialVersionUID = -7468103369804662814L;
        private final List<E> backend;

        private JavaBasedImmutableList(List<E> backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean contains(E element) {
            return this.backend.contains(element);
        }

        @Override
        public ImmutableList<E> reverse() {
            List<E> newList = this.toList();
            Collections.reverse(newList);
            return new JavaBasedImmutableList<E>(newList);
        }

        @Override
        public ImmutableList<E> sort(Comparator<E> comparator) {
            List<E> newList = this.toList();
            Collections.sort(newList, comparator);
            return new JavaBasedImmutableList<E>(newList);
        }

        @Override
        public ImmutableList<E> append(E element) {
            List<E> newList = this.toList();
            newList.add(element);
            return new JavaBasedImmutableList<E>(newList);
        }

        @Override
        public ImmutableList<E> remove(E element) {
            List<E> newList = this.toList();
            newList.remove(element);
            return new JavaBasedImmutableList<E>(newList);
        }

        @Override
        public ImmutableList<E> appendAll(Sequence<E> other) {
            List newList = this.toList();
            for (Object element : other) {
                newList.add(element);
            }
            return new JavaBasedImmutableList<E>(newList);
        }

        @Override
        public ImmutableList<E> removeAll(Sequence<E> other) {
            List<E> newList = this.toList();
            for (Object element : other) {
                newList.remove(element);
            }
            return new JavaBasedImmutableList<E>(newList);
        }

        @Override
        public Iterator<E> iterator() {
            return this.backend.iterator();
        }

        @Override
        public List<E> toList() {
            return new LinkedList<E>(this.backend);
        }

        public int hashCode() {
            return Objects.hash(this.backend);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append((a, b) -> Objects.equals(a.backend, b.backend)).applyTo(obj);
        }

        public String toString() {
            return "ImmutableList(" + this.backend + ")";
        }
    }
}

