/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Consumer2;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Operator2;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Tuple;
import com.github.tonivade.purefun.Tuple2;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ImmutableMap<K, V> {
    public Map<K, V> toMap();

    public ImmutableMap<K, V> put(K var1, V var2);

    public ImmutableMap<K, V> putAll(ImmutableSet<Tuple2<K, V>> var1);

    public ImmutableMap<K, V> remove(K var1);

    public Option<V> get(K var1);

    public Sequence<V> values();

    public ImmutableSet<K> keys();

    public ImmutableSet<Tuple2<K, V>> entries();

    public ImmutableMap<K, V> merge(K var1, V var2, Operator2<V> var3);

    public int size();

    default public void forEach(Consumer2<K, V> consumer) {
        this.entries().forEach((? super T tuple) -> consumer.accept(tuple.get1(), tuple.get2()));
    }

    default public <A, B> ImmutableMap<A, B> map(Function1<K, A> keyMapper, Function1<V, B> valueMapper) {
        return ImmutableMap.from(this.entries().map(tuple -> tuple.map(keyMapper, valueMapper)));
    }

    default public <A> ImmutableMap<A, V> mapKeys(Function1<K, A> mapper) {
        return ImmutableMap.from(this.entries().map(tuple -> tuple.map1(mapper)));
    }

    default public <A> ImmutableMap<K, A> mapValues(Function1<V, A> mapper) {
        return ImmutableMap.from(this.entries().map(tuple -> tuple.map2(mapper)));
    }

    default public ImmutableMap<K, V> filterKeys(Matcher1<K> filter) {
        return ImmutableMap.from(this.entries().filter(tuple -> filter.match(tuple.get1())));
    }

    default public ImmutableMap<K, V> filterValues(Matcher1<V> filter) {
        return ImmutableMap.from(this.entries().filter(tuple -> filter.match(tuple.get2())));
    }

    default public boolean containsKey(K key) {
        return this.get(key).isPresent();
    }

    default public ImmutableMap<K, V> putIfAbsent(K key, V value) {
        if (this.containsKey(key)) {
            return this;
        }
        return this.put(key, value);
    }

    default public V getOrDefault(K key, Producer<V> supplier) {
        return this.get(key).orElse(supplier);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @SafeVarargs
    public static <K, V> ImmutableMap<K, V> of(Tuple2<K, V> ... entries) {
        return ImmutableMap.from(ImmutableSet.of(entries));
    }

    public static <K, V> Tuple2<K, V> entry(K key, V value) {
        return Tuple2.of(key, value);
    }

    public static <K, V> ImmutableMap<K, V> from(Map<K, V> map) {
        return new JavaBasedImmutableMap(map);
    }

    public static <K, V> ImmutableMap<K, V> empty() {
        return new JavaBasedImmutableMap(Collections.emptyMap());
    }

    public static <K, V> ImmutableMap<K, V> from(Stream<Tuple2<K, V>> entries) {
        return ImmutableMap.from(ImmutableSet.from(entries));
    }

    public static <K, V> ImmutableMap<K, V> from(ImmutableSet<Tuple2<K, V>> entries) {
        return new JavaBasedImmutableMap(entries.stream().collect(Collectors.toMap(Tuple2::get1, Tuple2::get2)));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class JavaBasedImmutableMap<K, V>
    implements ImmutableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -1236334562860351635L;
        private final Map<K, V> backend;

        private JavaBasedImmutableMap(Map<K, V> backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        public Map<K, V> toMap() {
            return new HashMap<K, V>(this.backend);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public ImmutableMap<K, V> put(K key, V value) {
            Map<K, V> newMap = this.toMap();
            newMap.put(key, value);
            return new JavaBasedImmutableMap<K, V>(newMap);
        }

        @Override
        public ImmutableMap<K, V> putAll(ImmutableSet<Tuple2<K, V>> other) {
            Map<K, V> newMap = this.toMap();
            newMap.putAll(ImmutableMap.from(other).toMap());
            return new JavaBasedImmutableMap<K, V>(newMap);
        }

        @Override
        public ImmutableMap<K, V> remove(K key) {
            Map<K, V> newMap = this.toMap();
            newMap.remove(key);
            return new JavaBasedImmutableMap<K, V>(newMap);
        }

        @Override
        public Option<V> get(K key) {
            return Option.of(() -> this.backend.get(key));
        }

        @Override
        public ImmutableMap<K, V> merge(K key, V value, Operator2<V> merger) {
            Map<K, Object> newMap = this.toMap();
            newMap.merge(key, value, merger::apply);
            return new JavaBasedImmutableMap<K, V>(newMap);
        }

        @Override
        public Sequence<V> values() {
            return ImmutableList.from(this.backend.values());
        }

        @Override
        public ImmutableSet<K> keys() {
            return ImmutableSet.from(this.backend.keySet());
        }

        @Override
        public ImmutableSet<Tuple2<K, V>> entries() {
            return ImmutableSet.from(this.backend.entrySet()).map(Tuple::from);
        }

        public int hashCode() {
            return Objects.hash(this.backend);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append((a, b) -> Objects.equals(a.backend, b.backend)).applyTo(obj);
        }

        public String toString() {
            return "ImmutableMap(" + this.backend + ")";
        }
    }

    public static final class Builder<K, V> {
        private final Map<K, V> map = new HashMap();

        private Builder() {
        }

        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public ImmutableMap<K, V> build() {
            return ImmutableMap.from(this.map);
        }
    }
}

