/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ImmutableSet<E>
extends Sequence<E> {
    public Set<E> toSet();

    @Override
    public ImmutableSet<E> append(E var1);

    @Override
    public ImmutableSet<E> remove(E var1);

    @Override
    public ImmutableSet<E> appendAll(Sequence<E> var1);

    @Override
    public ImmutableSet<E> removeAll(Sequence<E> var1);

    @Override
    public ImmutableSet<E> reverse();

    public ImmutableSet<E> union(ImmutableSet<E> var1);

    public ImmutableSet<E> intersection(ImmutableSet<E> var1);

    public ImmutableSet<E> difference(ImmutableSet<E> var1);

    @Override
    default public <R> ImmutableSet<R> map(Function1<E, R> mapper) {
        return ImmutableSet.from(this.stream().map(mapper::apply));
    }

    @Override
    default public <R> ImmutableSet<R> flatMap(Function1<E, ? extends Higher1<Sequence.\u00b5, R>> mapper) {
        return ImmutableSet.from(this.stream().flatMap((? super T element) -> Sequence.narrowK((Higher1)mapper.apply(element)).stream()));
    }

    @Override
    default public ImmutableSet<E> filter(Matcher1<E> matcher) {
        return ImmutableSet.from(this.stream().filter(matcher::match));
    }

    public static <T> ImmutableSet<T> from(Iterable<T> iterable) {
        return ImmutableSet.from(Sequence.asStream(iterable.iterator()));
    }

    public static <T> ImmutableSet<T> from(Stream<T> stream) {
        return new JavaBasedImmutableSet(stream.collect(Collectors.toSet()));
    }

    @SafeVarargs
    public static <T> ImmutableSet<T> of(T ... elements) {
        return new JavaBasedImmutableSet(new LinkedHashSet<T>(Arrays.asList(elements)));
    }

    public static <T> ImmutableSet<T> empty() {
        return new JavaBasedImmutableSet(Collections.emptySet());
    }

    public static final class JavaBasedImmutableSet<E>
    implements ImmutableSet<E>,
    Serializable {
        private static final long serialVersionUID = -4111867323115030715L;
        private final Set<E> backend;

        private JavaBasedImmutableSet(Set<E> backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean contains(E element) {
            return this.backend.contains(element);
        }

        @Override
        public ImmutableSet<E> reverse() {
            return this;
        }

        @Override
        public ImmutableSet<E> append(E element) {
            Set<E> newSet = this.toSet();
            newSet.add(element);
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public ImmutableSet<E> appendAll(Sequence<E> other) {
            Set newSet = this.toSet();
            for (Object element : other) {
                newSet.add(element);
            }
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public ImmutableSet<E> removeAll(Sequence<E> other) {
            Set<E> newSet = this.toSet();
            for (Object element : other) {
                newSet.remove(element);
            }
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public ImmutableSet<E> remove(E element) {
            Set<E> newSet = this.toSet();
            newSet.remove(element);
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public ImmutableSet<E> union(ImmutableSet<E> other) {
            Set<E> newSet = this.toSet();
            newSet.addAll(other.toSet());
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public ImmutableSet<E> intersection(ImmutableSet<E> other) {
            Set<E> newSet = this.toSet();
            newSet.retainAll(other.toSet());
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public ImmutableSet<E> difference(ImmutableSet<E> other) {
            Set<E> newSet = this.toSet();
            newSet.removeAll(other.toSet());
            return new JavaBasedImmutableSet<E>(newSet);
        }

        @Override
        public Iterator<E> iterator() {
            return this.backend.iterator();
        }

        @Override
        public Set<E> toSet() {
            return new HashSet<E>(this.backend);
        }

        public int hashCode() {
            return Objects.hash(this.backend);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append((a, b) -> Objects.equals(a.backend, b.backend)).applyTo(obj);
        }

        public String toString() {
            return "ImmutableSet(" + this.backend + ")";
        }
    }
}

