/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ImmutableTree<E>
extends Sequence<E> {
    public NavigableSet<E> toNavigableSet();

    @Override
    public ImmutableTree<E> append(E var1);

    @Override
    public ImmutableTree<E> remove(E var1);

    @Override
    public ImmutableTree<E> appendAll(Sequence<E> var1);

    @Override
    public ImmutableTree<E> removeAll(Sequence<E> var1);

    @Override
    public ImmutableTree<E> reverse();

    public Option<E> head();

    public Option<E> tail();

    public ImmutableTree<E> headTree(E var1);

    public ImmutableTree<E> tailTree(E var1);

    public Option<E> higher(E var1);

    public Option<E> lower(E var1);

    public Option<E> ceiling(E var1);

    public Option<E> floor(E var1);

    @Override
    default public <R> ImmutableTree<R> map(Function1<E, R> mapper) {
        return ImmutableTree.from(this.stream().map(mapper::apply));
    }

    @Override
    default public <R> ImmutableTree<R> flatMap(Function1<E, ? extends Higher1<Sequence.\u00b5, R>> mapper) {
        return ImmutableTree.from(this.stream().flatMap((? super T element) -> Sequence.narrowK((Higher1)mapper.apply(element)).stream()));
    }

    @Override
    default public ImmutableTree<E> filter(Matcher1<E> matcher) {
        return ImmutableTree.from(this.stream().filter(matcher::match));
    }

    public static <T> ImmutableTree<T> from(Iterable<T> iterable) {
        return ImmutableTree.from(Sequence.asStream(iterable.iterator()));
    }

    public static <T> ImmutableTree<T> from(Stream<T> stream) {
        return new JavaBasedImmutableTree(stream.collect(Collectors.toCollection(TreeSet::new)));
    }

    @SafeVarargs
    public static <T> ImmutableTree<T> of(T ... elements) {
        return new JavaBasedImmutableTree(new TreeSet<T>(Arrays.asList(elements)));
    }

    public static <T> ImmutableTree<T> empty() {
        return new JavaBasedImmutableTree(Collections.emptyNavigableSet());
    }

    public static final class JavaBasedImmutableTree<E>
    implements ImmutableTree<E>,
    Serializable {
        private static final long serialVersionUID = -328223831102407507L;
        private final NavigableSet<E> backend;

        private JavaBasedImmutableTree(NavigableSet<E> backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean contains(E element) {
            return this.backend.contains(element);
        }

        @Override
        public ImmutableTree<E> reverse() {
            return this;
        }

        @Override
        public ImmutableTree<E> append(E element) {
            NavigableSet<E> newSet = this.toNavigableSet();
            newSet.add(element);
            return new JavaBasedImmutableTree<E>(newSet);
        }

        @Override
        public ImmutableTree<E> remove(E element) {
            NavigableSet<E> newSet = this.toNavigableSet();
            newSet.remove(element);
            return new JavaBasedImmutableTree<E>(newSet);
        }

        @Override
        public ImmutableTree<E> appendAll(Sequence<E> other) {
            NavigableSet newSet = this.toNavigableSet();
            for (Object element : other) {
                newSet.add(element);
            }
            return new JavaBasedImmutableTree<E>(newSet);
        }

        @Override
        public ImmutableTree<E> removeAll(Sequence<E> other) {
            NavigableSet<E> newSet = this.toNavigableSet();
            for (Object element : other) {
                newSet.remove(element);
            }
            return new JavaBasedImmutableTree<E>(newSet);
        }

        @Override
        public Option<E> head() {
            return Try.of(this.backend::first).toOption();
        }

        @Override
        public Option<E> tail() {
            return Try.of(this.backend::last).toOption();
        }

        @Override
        public ImmutableTree<E> headTree(E toElement) {
            return new JavaBasedImmutableTree<E>(this.backend.headSet(toElement, false));
        }

        @Override
        public ImmutableTree<E> tailTree(E fromElement) {
            return new JavaBasedImmutableTree<E>(this.backend.tailSet(fromElement, false));
        }

        @Override
        public Option<E> higher(E value) {
            return Option.of(() -> this.backend.higher(value));
        }

        @Override
        public Option<E> lower(E value) {
            return Option.of(() -> this.backend.lower(value));
        }

        @Override
        public Option<E> ceiling(E value) {
            return Option.of(() -> this.backend.ceiling(value));
        }

        @Override
        public Option<E> floor(E value) {
            return Option.of(() -> this.backend.floor(value));
        }

        @Override
        public Iterator<E> iterator() {
            return this.backend.iterator();
        }

        @Override
        public NavigableSet<E> toNavigableSet() {
            return new TreeSet<E>(this.backend);
        }

        public int hashCode() {
            return Objects.hash(this.backend);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append((a, b) -> Objects.equals(a.backend, b.backend)).applyTo(obj);
        }

        public String toString() {
            return "ImmutableTree(" + this.backend + ")";
        }
    }
}

