/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Operator2;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Tuple;
import com.github.tonivade.purefun.Tuple2;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purefun.data.ImmutableTreeModule;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ImmutableTreeMap<K, V>
extends ImmutableMap<K, V> {
    public NavigableMap<K, V> toNavigableMap();

    @Override
    public ImmutableTreeMap<K, V> put(K var1, V var2);

    @Override
    public ImmutableTreeMap<K, V> putAll(ImmutableSet<Tuple2<K, V>> var1);

    @Override
    public ImmutableTreeMap<K, V> remove(K var1);

    @Override
    public ImmutableTreeMap<K, V> merge(K var1, V var2, Operator2<V> var3);

    public ImmutableTreeMap<K, V> headMap(K var1);

    public ImmutableTreeMap<K, V> tailMap(K var1);

    public Option<Tuple2<K, V>> headEntry();

    public Option<Tuple2<K, V>> tailEntry();

    public Option<Tuple2<K, V>> higherEntry(K var1);

    public Option<Tuple2<K, V>> lowerEntry(K var1);

    public Option<Tuple2<K, V>> floorEntry(K var1);

    public Option<Tuple2<K, V>> ceilingEntry(K var1);

    default public Option<K> headKey() {
        return this.headEntry().map(Tuple2::get1);
    }

    default public Option<K> tailKey() {
        return this.tailEntry().map(Tuple2::get1);
    }

    default public Option<K> higherKey(K key) {
        return this.higherEntry(key).map(Tuple2::get1);
    }

    default public Option<K> lowerKey(K key) {
        return this.lowerEntry(key).map(Tuple2::get1);
    }

    default public Option<K> floorKey(K key) {
        return this.floorEntry(key).map(Tuple2::get1);
    }

    default public Option<K> ceilingKey(K key) {
        return this.floorEntry(key).map(Tuple2::get1);
    }

    @Override
    default public <A, B> ImmutableTreeMap<A, B> map(Function1<K, A> keyMapper, Function1<V, B> valueMapper) {
        return ImmutableTreeMap.from(this.entries().map(tuple -> tuple.map(keyMapper, valueMapper)));
    }

    @Override
    default public <A> ImmutableTreeMap<A, V> mapKeys(Function1<K, A> mapper) {
        return ImmutableTreeMap.from(this.entries().map(tuple -> tuple.map1(mapper)));
    }

    @Override
    default public <A> ImmutableTreeMap<K, A> mapValues(Function1<V, A> mapper) {
        return ImmutableTreeMap.from(this.entries().map(tuple -> tuple.map2(mapper)));
    }

    @Override
    default public ImmutableTreeMap<K, V> filterKeys(Matcher1<K> filter) {
        return ImmutableTreeMap.from(this.entries().filter(tuple -> filter.match(tuple.get1())));
    }

    @Override
    default public ImmutableTreeMap<K, V> filterValues(Matcher1<V> filter) {
        return ImmutableTreeMap.from(this.entries().filter(tuple -> filter.match(tuple.get2())));
    }

    @Override
    default public ImmutableTreeMap<K, V> putIfAbsent(K key, V value) {
        if (this.containsKey(key)) {
            return this;
        }
        return this.put((Object)key, (Object)value);
    }

    @Override
    default public V getOrDefault(K key, Producer<V> supplier) {
        return this.get(key).orElse(supplier);
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @SafeVarargs
    public static <K, V> ImmutableTreeMap<K, V> of(Tuple2<K, V> ... entries) {
        return ImmutableTreeMap.from(ImmutableSet.of(entries));
    }

    public static <K, V> Tuple2<K, V> entry(K key, V value) {
        return Tuple2.of(key, value);
    }

    public static <K, V> ImmutableTreeMap<K, V> from(NavigableMap<K, V> map) {
        return new JavaBasedImmutableTreeMap(map);
    }

    public static <K, V> ImmutableTreeMap<K, V> empty() {
        return new JavaBasedImmutableTreeMap(Collections.emptyNavigableMap());
    }

    public static <K, V> ImmutableTreeMap<K, V> from(Stream<Tuple2<K, V>> entries) {
        return ImmutableTreeMap.from(ImmutableSet.from(entries));
    }

    public static <K, V> ImmutableTreeMap<K, V> from(ImmutableSet<Tuple2<K, V>> entries) {
        return new JavaBasedImmutableTreeMap(entries.stream().collect(Collectors.toMap(Tuple2::get1, Tuple2::get2, ImmutableTreeModule.throwingMerge(), TreeMap::new)));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class JavaBasedImmutableTreeMap<K, V>
    implements ImmutableTreeMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 8618845296089216532L;
        private final NavigableMap<K, V> backend;

        private JavaBasedImmutableTreeMap(NavigableMap<K, V> backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        public Map<K, V> toMap() {
            return this.toNavigableMap();
        }

        @Override
        public NavigableMap<K, V> toNavigableMap() {
            return new TreeMap<K, V>(this.backend);
        }

        @Override
        public ImmutableTreeMap<K, V> put(K key, V value) {
            NavigableMap<K, V> newMap = this.toNavigableMap();
            newMap.put(key, value);
            return new JavaBasedImmutableTreeMap<K, V>(newMap);
        }

        @Override
        public ImmutableTreeMap<K, V> putAll(ImmutableSet<Tuple2<K, V>> other) {
            NavigableMap newMap = this.toNavigableMap();
            newMap.putAll(ImmutableTreeMap.from(other).toMap());
            return new JavaBasedImmutableTreeMap<K, V>(newMap);
        }

        @Override
        public ImmutableTreeMap<K, V> remove(K key) {
            NavigableMap<K, V> newMap = this.toNavigableMap();
            newMap.remove(key);
            return new JavaBasedImmutableTreeMap<K, V>(newMap);
        }

        @Override
        public Option<V> get(K key) {
            return Option.of(() -> this.backend.get(key));
        }

        @Override
        public ImmutableTreeMap<K, V> merge(K key, V value, Operator2<V> merger) {
            NavigableMap<K, Object> newMap = this.toNavigableMap();
            newMap.merge(key, value, merger::apply);
            return new JavaBasedImmutableTreeMap<K, V>(newMap);
        }

        @Override
        public ImmutableTreeMap<K, V> headMap(K toKey) {
            return new JavaBasedImmutableTreeMap<K, V>(this.backend.headMap(toKey, false));
        }

        @Override
        public ImmutableTreeMap<K, V> tailMap(K fromKey) {
            return new JavaBasedImmutableTreeMap<K, V>(this.backend.tailMap(fromKey, false));
        }

        @Override
        public Option<Tuple2<K, V>> headEntry() {
            return Try.of(() -> Tuple.from(this.backend.firstEntry())).toOption();
        }

        @Override
        public Option<Tuple2<K, V>> tailEntry() {
            return Try.of(() -> Tuple.from(this.backend.lastEntry())).toOption();
        }

        @Override
        public Option<Tuple2<K, V>> higherEntry(K key) {
            return Try.of(() -> Tuple.from(this.backend.higherEntry(key))).toOption();
        }

        @Override
        public Option<Tuple2<K, V>> lowerEntry(K key) {
            return Try.of(() -> Tuple.from(this.backend.lowerEntry(key))).toOption();
        }

        @Override
        public Option<Tuple2<K, V>> floorEntry(K key) {
            return Try.of(() -> Tuple.from(this.backend.floorEntry(key))).toOption();
        }

        @Override
        public Option<Tuple2<K, V>> ceilingEntry(K key) {
            return Try.of(() -> Tuple.from(this.backend.ceilingEntry(key))).toOption();
        }

        @Override
        public Sequence<V> values() {
            return ImmutableList.from(this.backend.values());
        }

        @Override
        public ImmutableSet<K> keys() {
            return ImmutableSet.from(this.backend.keySet());
        }

        @Override
        public ImmutableSet<Tuple2<K, V>> entries() {
            return ImmutableSet.from(this.backend.entrySet()).map(Tuple::from);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        public int hashCode() {
            return Objects.hash(this.backend);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append((a, b) -> Objects.equals(a.backend, b.backend)).applyTo(obj);
        }

        public String toString() {
            return "ImmutableTreeMap(" + this.backend + ")";
        }
    }

    public static final class Builder<K, V> {
        private final NavigableMap<K, V> map = new TreeMap();

        private Builder() {
        }

        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public ImmutableTreeMap<K, V> build() {
            return ImmutableTreeMap.from(this.map);
        }
    }
}

