/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.data;

import com.github.tonivade.purefun.Filterable;
import com.github.tonivade.purefun.FlatMap1;
import com.github.tonivade.purefun.Foldable;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Operator2;
import com.github.tonivade.purefun.data.ImmutableArray;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purefun.data.ImmutableTree;
import com.github.tonivade.purefun.handler.SequenceHandler;
import com.github.tonivade.purefun.type.Option;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Sequence<E>
extends Iterable<E>,
FlatMap1<\u00b5, E>,
Filterable<E>,
Foldable<E> {
    public int size();

    public boolean contains(E var1);

    public Sequence<E> append(E var1);

    public Sequence<E> remove(E var1);

    public Sequence<E> appendAll(Sequence<E> var1);

    public Sequence<E> removeAll(Sequence<E> var1);

    public Sequence<E> reverse();

    public <R> Sequence<R> map(Function1<E, R> var1);

    public <R> Sequence<R> flatMap(Function1<E, ? extends Higher1<\u00b5, R>> var1);

    default public <V> Sequence<V> flatten() {
        try {
            return this.flatMap((Function1)SequenceHandler.identity());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("cannot be flattened");
        }
    }

    @Override
    public Sequence<E> filter(Matcher1<E> var1);

    @Override
    default public Option<E> reduce(Operator2<E> operator) {
        return Option.from(this.stream().reduce(operator::apply));
    }

    @Override
    default public E fold(E initial, Operator2<E> operator) {
        return this.stream().reduce(initial, operator::apply);
    }

    @Override
    default public <U> U foldLeft(U initial, Function2<U, E, U> combinator) {
        U accumulator = initial;
        for (Object element : this) {
            accumulator = combinator.apply(accumulator, element);
        }
        return accumulator;
    }

    @Override
    default public <U> U foldRight(U initial, Function2<E, U, U> combinator) {
        return (U)this.reverse().foldLeft(initial, (Function2<U, Object, U>)((Function2<Object, Object, Object>)(acc, e) -> combinator.apply(e, acc)));
    }

    default public <G> ImmutableMap<G, ImmutableList<E>> groupBy(Function1<E, G> selector) {
        return ImmutableMap.from(this.stream().collect(Collectors.groupingBy(selector::apply))).mapValues(ImmutableList::from);
    }

    default public ImmutableList<E> asList() {
        return ImmutableList.from(this.stream());
    }

    default public ImmutableArray<E> asArray() {
        return ImmutableArray.from(this.stream());
    }

    default public ImmutableSet<E> asSet() {
        return ImmutableSet.from(this.stream());
    }

    default public ImmutableTree<E> asTree() {
        return ImmutableTree.from(this.stream());
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @SafeVarargs
    public static <E> ImmutableArray<E> arrayOf(E ... elements) {
        return ImmutableArray.of(elements);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> listOf(E ... elements) {
        return ImmutableList.of(elements);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> setOf(E ... elements) {
        return ImmutableSet.of(elements);
    }

    @SafeVarargs
    public static <E> ImmutableTree<E> treeOf(E ... elements) {
        return ImmutableTree.of(elements);
    }

    public static <E> Stream<E> asStream(Iterator<E> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Sequence<T> narrowK(Higher1<\u00b5, T> hkt) {
        return (Sequence)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }
}

