/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.handler;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.handler.OptionHandler;
import com.github.tonivade.purefun.type.Either;

@FunctionalInterface
public interface EitherHandler<T, L, R>
extends Function1<T, Either<L, R>> {
    default public <V> EitherHandler<V, L, R> compose(Function1<V, T> before) {
        return value -> (Either)this.apply(before.apply(value));
    }

    default public <V> EitherHandler<T, L, V> map(Function1<R, V> mapper) {
        return value -> ((Either)this.apply(value)).map(mapper::apply);
    }

    default public <V> EitherHandler<T, V, R> mapLeft(Function1<L, V> mapper) {
        return value -> ((Either)this.apply(value)).mapLeft(mapper::apply);
    }

    default public <V> EitherHandler<T, L, V> flatMap(EitherHandler<R, L, V> mapper) {
        return value -> ((Either)this.apply(value)).flatMap(mapper::apply);
    }

    default public <V> EitherHandler<T, L, V> flatten() {
        return value -> ((Either)this.apply(value)).flatten();
    }

    default public OptionHandler<T, Either<L, R>> filter(Matcher1<R> matcher) {
        return value -> ((Either)this.apply(value)).filter(matcher);
    }

    default public Function1<T, R> orElse(Producer<R> producer) {
        return value -> ((Either)this.apply(value)).orElse(producer);
    }

    public static <L, R> Function1<Either<L, R>, Either<L, R>> identity() {
        return Function1.identity()::apply;
    }

    public static <T, L, R> EitherHandler<T, L, R> of(Function1<T, Either<L, R>> reference) {
        return reference::apply;
    }
}

