/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.handler;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.handler.OptionalHandler;
import com.github.tonivade.purefun.type.Option;

@FunctionalInterface
public interface OptionHandler<T, R>
extends Function1<T, Option<R>> {
    @Override
    default public <V> OptionHandler<V, R> compose(Function1<V, T> before) {
        return value -> (Option)this.apply(before.apply(value));
    }

    default public <V> OptionHandler<T, V> map(Function1<R, V> mapper) {
        return value -> ((Option)this.apply(value)).map(mapper::apply);
    }

    default public <V> OptionHandler<T, V> flatMap(OptionHandler<R, V> mapper) {
        return value -> ((Option)this.apply(value)).flatMap(mapper::apply);
    }

    default public <V> OptionHandler<T, V> flatten() {
        return value -> ((Option)this.apply(value)).flatten();
    }

    default public OptionHandler<T, R> filter(Matcher1<R> matcher) {
        return value -> ((Option)this.apply(value)).filter((Matcher1)matcher);
    }

    default public Function1<T, R> orElse(R value) {
        return this.orElse(Producer.unit(value));
    }

    default public Function1<T, R> orElse(Producer<R> producer) {
        return value -> ((Option)this.apply(value)).orElse(producer);
    }

    default public OptionalHandler<T, R> toOptional() {
        return value -> ((Option)this.apply(value)).toOptional();
    }

    public static <T, R> OptionHandler<T, R> of(Function1<T, Option<R>> reference) {
        return reference::apply;
    }

    public static <T> OptionHandler<Option<T>, T> identity() {
        return Function1.identity()::apply;
    }
}

