/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.handler;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface OptionalHandler<T, R>
extends Function1<T, Optional<R>> {
    @Override
    default public <V> OptionalHandler<V, R> compose(Function1<V, T> before) {
        return value -> (Optional)this.apply(before.apply(value));
    }

    default public <V> OptionalHandler<T, V> map(Function1<R, V> mapper) {
        return value -> ((Optional)this.apply(value)).map(mapper::apply);
    }

    default public <V> OptionalHandler<T, V> flatMap(OptionalHandler<R, V> mapper) {
        return value -> ((Optional)this.apply(value)).flatMap(mapper::apply);
    }

    default public <V> OptionalHandler<T, V> flatten() {
        return value -> ((Optional)this.apply(value)).flatMap(Function.identity());
    }

    default public OptionalHandler<T, R> filter(Matcher1<R> matcher) {
        return value -> ((Optional)this.apply(value)).filter(matcher::match);
    }

    default public Function1<T, R> orElse(Producer<R> producer) {
        return value -> ((Optional)this.apply(value)).orElseGet(producer::get);
    }

    public static <T, R> OptionalHandler<T, R> of(Function1<T, Optional<R>> reference) {
        return reference::apply;
    }
}

