/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.handler;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.handler.StreamHandler;

@FunctionalInterface
public interface SequenceHandler<T, R>
extends Function1<T, Sequence<R>> {
    @Override
    default public <V> SequenceHandler<V, R> compose(Function1<V, T> before) {
        return value -> (Sequence)this.apply(before.apply(value));
    }

    default public <V> SequenceHandler<T, V> map(Function1<R, V> mapper) {
        return value -> ((Sequence)this.apply(value)).map(mapper::apply);
    }

    default public <V> SequenceHandler<T, V> flatMap(SequenceHandler<R, V> mapper) {
        return value -> ((Sequence)this.apply(value)).flatMap(mapper::apply);
    }

    default public <V> SequenceHandler<T, V> flatten() {
        return value -> ((Sequence)this.apply(value)).flatten();
    }

    default public SequenceHandler<T, R> filter(Matcher1<R> matcher) {
        return value -> ((Sequence)this.apply(value)).filter(matcher::match);
    }

    default public StreamHandler<T, R> toStreamHandler() {
        return value -> ((Sequence)this.apply(value)).stream();
    }

    public static <T> SequenceHandler<Sequence<T>, T> identity() {
        return Function1.identity()::apply;
    }

    public static <T, R> SequenceHandler<T, R> of(Function1<T, Sequence<R>> reference) {
        return reference::apply;
    }
}

