/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.handler;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.handler.SequenceHandler;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

@FunctionalInterface
public interface StreamHandler<T, R>
extends Function1<T, Stream<R>> {
    @Override
    default public <V> StreamHandler<V, R> compose(Function1<V, T> before) {
        return value -> (Stream)this.apply(before.apply(value));
    }

    default public <V> StreamHandler<T, V> map(Function1<R, V> mapper) {
        return value -> ((Stream)this.apply(value)).map(mapper::apply);
    }

    default public <V> StreamHandler<T, V> flatMap(StreamHandler<R, V> mapper) {
        return value -> ((Stream)this.apply(value)).flatMap(mapper::apply);
    }

    default public <V> StreamHandler<T, V> flatten() {
        return value -> ((Stream)this.apply(value)).flatMap(Function.identity());
    }

    default public StreamHandler<T, R> filter(Matcher1<R> matcher) {
        return value -> ((Stream)this.apply(value)).filter(matcher::match);
    }

    default public SequenceHandler<T, R> toSequenceHandler() {
        return value -> ImmutableList.from((Stream)this.apply(value));
    }

    default public <A, V> Function1<T, V> collect(Collector<R, A, V> collector) {
        return value -> ((Stream)this.apply(value)).collect(collector);
    }

    public static <T, R> StreamHandler<T, R> of(Function1<T, Stream<R>> reference) {
        return reference::apply;
    }
}

