/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.FlatMap2;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.algebra.Functor;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.algebra.Transformer;
import com.github.tonivade.purefun.monad.FreeModule;
import com.github.tonivade.purefun.type.Either;
import java.util.Objects;

public interface Free<F extends Kind, T>
extends FlatMap2<\u00b5, F, T> {
    public static <F extends Kind, T> Free<F, T> pure(T value) {
        return new Pure(value);
    }

    public static <F extends Kind, T> Free<F, T> suspend(Higher1<F, Free<F, T>> value) {
        return new Suspend(value);
    }

    public static <F extends Kind, T> Free<F, T> liftF(Functor<F> functor, Higher1<F, T> value) {
        return Free.suspend(functor.map(value, Free::pure));
    }

    public static <F extends Kind, T> Free<F, T> narrowK(Higher2<\u00b5, F, T> hkt) {
        return (Free)hkt;
    }

    public static <F extends Kind, T> Free<F, T> narrowK(Higher1<Higher1<\u00b5, F>, T> hkt) {
        return (Free)hkt;
    }

    @Override
    default public <R> Free<F, R> map(Function1<T, R> map) {
        return this.flatMap(map.andThen(Free::pure));
    }

    public <R> Free<F, R> flatMap(Function1<T, ? extends Higher2<\u00b5, F, R>> var1);

    default public <R> Free<F, R> andThen(Free<F, R> next) {
        return this.flatMap((T ignore) -> next);
    }

    default public Either<Higher1<F, Free<F, T>>, T> resume(Functor<F> functor) {
        return FreeModule.resume(this, functor);
    }

    default public <G extends Kind> Higher1<G, T> foldMap(Monad<G> monad, Functor<F> functor, Transformer<F, G> interpreter) {
        return this.resume(functor).fold(left -> FreeModule.suspend(monad, functor, interpreter, left), monad::pure);
    }

    public FreeModule module();

    public static final class FlatMapped<F extends Kind, T, R>
    implements Free<F, R> {
        final Higher2<\u00b5, F, T> value;
        final Function1<T, ? extends Higher2<\u00b5, F, R>> map;

        private FlatMapped(Higher2<\u00b5, F, T> value, Function1<T, ? extends Higher2<\u00b5, F, R>> map) {
            this.value = Objects.requireNonNull(value);
            this.map = Objects.requireNonNull(map);
        }

        @Override
        public <X> Free<F, X> flatMap(Function1<R, ? extends Higher2<\u00b5, F, X>> map) {
            return new FlatMapped<F, Object, R>(this.value, free -> new FlatMapped<F, T, R>(this.narrowFn().apply(free), map));
        }

        Function1<T, Free<F, R>> narrowFn() {
            return this.map.andThen(Free::narrowK);
        }

        Free<F, T> narrowK() {
            return Free.narrowK(this.value);
        }

        @Override
        public FreeModule module() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Suspend<F extends Kind, T>
    implements Free<F, T> {
        final Higher1<F, Free<F, T>> value;

        private Suspend(Higher1<F, Free<F, T>> value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public <R> Free<F, R> flatMap(Function1<T, ? extends Higher2<\u00b5, F, R>> map) {
            return new FlatMapped(this, map);
        }

        @Override
        public FreeModule module() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Pure<F extends Kind, T>
    implements Free<F, T> {
        final T value;

        private Pure(T value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public <R> Free<F, R> flatMap(Function1<T, ? extends Higher2<\u00b5, F, R>> map) {
            return new FlatMapped(this, map);
        }

        @Override
        public FreeModule module() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class \u00b5
    implements Kind {
    }
}

