/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.CheckedConsumer1;
import com.github.tonivade.purefun.FlatMap1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.monad.IOResource;

@FunctionalInterface
public interface IO<T>
extends FlatMap1<\u00b5, T> {
    public T unsafeRunSync();

    default public <R> IO<R> map(Function1<T, R> map) {
        return () -> map.apply(this.unsafeRunSync());
    }

    default public <R> IO<R> flatMap(Function1<T, ? extends Higher1<\u00b5, R>> map) {
        return () -> map.andThen(IO::narrowK).apply(this.unsafeRunSync()).unsafeRunSync();
    }

    default public <R> IO<R> andThen(IO<R> after) {
        return this.flatMap((T ignore) -> after);
    }

    public static <T> IO<T> pure(T value) {
        return () -> value;
    }

    public static <T, R> Function1<T, IO<R>> lift(Function1<T, R> task) {
        return task.andThen(IO::pure);
    }

    public static IO<Nothing> exec(Runnable task) {
        return () -> {
            task.run();
            return Nothing.nothing();
        };
    }

    public static <T> IO<T> of(Producer<T> producer) {
        return producer::get;
    }

    public static IO<Nothing> noop() {
        return IO.pure(Nothing.nothing());
    }

    public static <T, R> IO<R> bracket(IO<T> acquire, Function1<T, IO<R>> use, CheckedConsumer1<T> release) {
        return () -> {
            try (IOResource resource = new IOResource(acquire.unsafeRunSync(), release);){
                Object r = resource.apply(use).unsafeRunSync();
                return r;
            }
        };
    }

    public static <T extends AutoCloseable, R> IO<R> bracket(IO<T> acquire, Function1<T, IO<R>> use) {
        return IO.bracket(acquire, use, AutoCloseable::close);
    }

    public static IO<Nothing> sequence(Sequence<IO<?>> sequence) {
        return sequence.fold(IO.noop(), IO::andThen).andThen(IO.noop());
    }

    public static <T> IO<T> narrowK(Higher1<\u00b5, T> hkt) {
        return (IO)hkt;
    }

    public static Monad<\u00b5> monad() {
        return new Monad<\u00b5>(){

            public <T> IO<T> pure(T value) {
                return IO.pure(value);
            }

            public <T, R> IO<R> flatMap(Higher1<\u00b5, T> value, Function1<T, ? extends Higher1<\u00b5, R>> map) {
                return IO.narrowK(value).flatMap(map);
            }
        };
    }

    public static final class \u00b5
    implements Kind {
    }
}

