/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.FlatMap3;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Higher3;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.algebra.Monad;
import java.util.Objects;

public final class Kleisli<F extends Kind, Z, A>
implements FlatMap3<\u00b5, F, Z, A> {
    private final Monad<F> monad;
    private final Function1<Z, Higher1<F, A>> run;

    private Kleisli(Monad<F> monad, Function1<Z, Higher1<F, A>> run) {
        this.monad = Objects.requireNonNull(monad);
        this.run = Objects.requireNonNull(run);
    }

    public Higher1<F, A> run(Z value) {
        return this.run.apply(value);
    }

    public <R> Kleisli<F, Z, R> map(Function1<A, R> map) {
        return Kleisli.of(this.monad, value -> this.monad.map(this.run(value), map));
    }

    public <R> Kleisli<F, Z, R> flatMap(Function1<A, ? extends Higher3<\u00b5, F, Z, R>> map) {
        return Kleisli.of(this.monad, value -> this.monad.flatMap(this.run(value), a -> map.andThen(Kleisli::narrowK).apply(a).run(value)));
    }

    public <B> Kleisli<F, Z, B> compose(Kleisli<F, A, B> other) {
        return Kleisli.of(this.monad, value -> this.monad.flatMap(this.run(value), other::run));
    }

    public <X> Kleisli<F, X, A> local(Function1<X, Z> map) {
        return Kleisli.of(this.monad, map.andThen(this::run)::apply);
    }

    public static <F extends Kind, A, B> Kleisli<F, A, B> lift(Monad<F> monad, Function1<A, B> map) {
        return Kleisli.of(monad, map.andThen(monad::pure)::apply);
    }

    public static <F extends Kind, A, B> Kleisli<F, A, B> of(Monad<F> monad, Function1<A, Higher1<F, B>> run) {
        return new Kleisli<F, A, B>(monad, run);
    }

    public static <F extends Kind, A, B> Kleisli<F, A, B> narrowK(Higher3<\u00b5, F, A, B> hkt) {
        return (Kleisli)hkt;
    }

    public static <F extends Kind, A, B> Kleisli<F, A, B> narrowK(Higher2<Higher1<\u00b5, F>, A, B> hkt) {
        return (Kleisli)hkt;
    }

    public static <F extends Kind, A, B> Kleisli<F, A, B> narrowK(Higher1<Higher1<Higher1<\u00b5, F>, A>, B> hkt) {
        return (Kleisli)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }
}

