/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.FlatMap2;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Operator1;
import com.github.tonivade.purefun.Tuple2;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;

@FunctionalInterface
public interface State<S, A>
extends FlatMap2<\u00b5, S, A> {
    public Tuple2<S, A> run(S var1);

    @Override
    default public <R> State<S, R> map(Function1<A, R> mapper) {
        return this.flatMap((T value) -> State.pure(mapper.apply(value)));
    }

    default public <R> State<S, R> flatMap(Function1<A, ? extends Higher2<\u00b5, S, R>> mapper) {
        return state -> {
            Tuple2<Object, A> run = this.run(state);
            return mapper.andThen(State::narrowK).apply(run.get2()).run(run.get1());
        };
    }

    default public A eval(S state) {
        return this.run(state).get2();
    }

    public static <S, A> State<S, A> state(Function1<S, Tuple2<S, A>> runState) {
        return runState::apply;
    }

    public static <S, A> State<S, A> pure(A value) {
        return state -> Tuple2.of(state, value);
    }

    public static <S> State<S, S> get() {
        return state -> Tuple2.of(state, state);
    }

    public static <S> State<S, Nothing> set(S value) {
        return state -> Tuple2.of(value, Nothing.nothing());
    }

    public static <S> State<S, Nothing> modify(Operator1<S> mapper) {
        return state -> Tuple2.of(mapper.apply(state), Nothing.nothing());
    }

    public static <S, A> State<S, A> inspect(Function1<S, A> mapper) {
        return state -> Tuple2.of(state, mapper.apply(state));
    }

    public static <S, A> State<S, Sequence<A>> compose(Sequence<State<S, A>> states) {
        return states.foldLeft(State.pure(ImmutableList.empty()), (sa, sb) -> State.map2(sa, sb, (acc, a) -> acc.append(a)));
    }

    public static <S, A, B, C> State<S, C> map2(State<S, A> sa, State<S, B> sb, Function2<A, B, C> mapper) {
        return sa.flatMap((T a) -> sb.map(b -> mapper.curried().apply(a).apply(b)));
    }

    public static <S, A> State<S, A> narrowK(Higher2<\u00b5, S, A> hkt) {
        return (State)hkt;
    }

    public static <S, A> State<S, A> narrowK(Higher1<Higher1<\u00b5, S>, A> hkt) {
        return (State)hkt;
    }

    public static <V> Monad<Higher1<\u00b5, V>> monad() {
        return new Monad<Higher1<\u00b5, V>>(){

            @Override
            public <T> State<V, T> pure(T value) {
                return State.pure(value);
            }

            @Override
            public <T, R> State<V, R> flatMap(Higher1<Higher1<\u00b5, V>, T> value, Function1<T, ? extends Higher1<Higher1<\u00b5, V>, R>> map) {
                return State.narrowK(value).flatMap(map.andThen(State::narrowK));
            }
        };
    }

    public static final class \u00b5
    implements Kind {
    }
}

