/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.monad;

import com.github.tonivade.purefun.FlatMap2;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.algebra.Monoid;
import com.github.tonivade.purefun.algebra.MonoidK;
import com.github.tonivade.purefun.data.Sequence;
import java.util.Objects;

public final class Writer<L, A>
implements FlatMap2<\u00b5, L, A> {
    private final Monoid<L> monoid;
    private final A value;
    private final L log;

    private Writer(Monoid<L> monoid, L log, A value) {
        this.monoid = Objects.requireNonNull(monoid);
        this.log = Objects.requireNonNull(log);
        this.value = Objects.requireNonNull(value);
    }

    public A getValue() {
        return this.value;
    }

    public L getLog() {
        return this.log;
    }

    @Override
    public <B> Writer<L, B> map(Function1<A, B> map) {
        return new Writer<L, B>(this.monoid, this.log, map.apply(this.value));
    }

    public <B> Writer<L, B> flatMap(Function1<A, ? extends Higher2<\u00b5, L, B>> map) {
        Writer apply = map.andThen(Writer::narrowK).apply(this.value);
        return new Writer<L, A>(this.monoid, this.monoid.combine(this.log, apply.log), apply.value);
    }

    public static <L, A> Writer<L, A> pure(Monoid<L> monoid, A value) {
        return new Writer<L, A>(monoid, monoid.zero(), value);
    }

    public static <L, A> Writer<L, A> writer(Monoid<L> monoid, L log, A value) {
        return new Writer<L, A>(monoid, log, value);
    }

    public static <T, A> Writer<Higher1<Sequence.\u00b5, T>, A> listPure(A value) {
        return Writer.pure(MonoidK.sequence(), value);
    }

    public static <T, A> Writer<Higher1<Sequence.\u00b5, T>, A> listWriter(T log, A value) {
        return Writer.writer(MonoidK.sequence(), Sequence.listOf(log), value);
    }

    public static <L, T> Writer<L, T> narrowK(Higher2<\u00b5, L, T> hkt) {
        return (Writer)hkt;
    }

    public static <L, T> Writer<L, T> narrowK(Higher1<Higher1<\u00b5, L>, T> hkt) {
        return (Writer)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }
}

