/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.optics;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Operator1;
import java.util.Objects;

public final class Lens<T, R> {
    private final Function1<T, R> getter;
    private final Function2<T, R, T> setter;

    private Lens(Function1<T, R> getter, Function2<T, R, T> setter) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = Objects.requireNonNull(setter);
    }

    public static <T, R> Lens<T, R> of(Function1<T, R> getter, Function2<T, R, T> setter) {
        return new Lens<T, R>(getter, setter);
    }

    public R get(T target) {
        return this.getter.apply(target);
    }

    public T set(T target, R value) {
        return this.set(target).apply(value);
    }

    public Function1<R, T> set(T target) {
        return this.setter.curried().apply(target);
    }

    public Operator1<T> modify(Operator1<R> mapper) {
        return target -> this.set(target).apply(mapper.apply(this.getter.apply(target)));
    }

    public Operator1<T> modify(R newValue) {
        return this.modify((R)((Operator1)ignore -> newValue));
    }

    public <V> Lens<T, V> compose(Lens<R, V> other) {
        return new Lens<Object, Object>(target -> other.get(this.get(target)), (target, value) -> this.set(target).apply(other.modify(value).apply(this.get(target))));
    }
}

