/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.optics;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Operator1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.handler.OptionHandler;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import java.util.Objects;

public final class Prism<T, R> {
    private final OptionHandler<T, R> getOption;
    private final Function1<R, T> reverseGet;

    private Prism(OptionHandler<T, R> getOption, Function1<R, T> reverseGet) {
        this.getOption = Objects.requireNonNull(getOption);
        this.reverseGet = Objects.requireNonNull(reverseGet);
    }

    public static <T, R> Prism<T, R> of(OptionHandler<T, R> getOption, Function1<R, T> reverseGet) {
        return new Prism<T, R>(getOption, reverseGet);
    }

    public Option<R> getOption(T target) {
        return (Option)this.getOption.apply(target);
    }

    public T reverseGet(R value) {
        return this.reverseGet.apply(value);
    }

    public Either<T, R> getOrModify(T target) {
        return this.getOption(target).fold(Producer.unit(Either.left(target)), Either::right);
    }

    public Operator1<T> modify(Operator1<R> mapper) {
        return target -> ((Option)this.modifyOption(mapper).apply(target)).orElse(target);
    }

    public Operator1<T> set(R value) {
        return this.modify(ignore -> value);
    }

    public OptionHandler<T, T> modifyOption(Operator1<R> mapper) {
        return target -> this.getOption(target).map(mapper).map((Function1)this.reverseGet);
    }

    public OptionHandler<T, T> setOption(R value) {
        return this.modifyOption(ignore -> value);
    }

    public <V> Prism<T, V> compose(Prism<R, V> other) {
        return new Prism<Object, Object>(target -> this.getOption(target).flatMap(other::getOption), value -> this.reverseGet(other.reverseGet(value)));
    }
}

