/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.type;

import com.github.tonivade.purefun.FlatMap2;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Holder;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.handler.EitherHandler;
import com.github.tonivade.purefun.type.EitherModule;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Validation;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;

public interface Either<L, R>
extends FlatMap2<\u00b5, L, R>,
Holder<R> {
    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public static <L, R> Either<L, R> narrowK(Higher2<\u00b5, L, R> hkt) {
        return (Either)hkt;
    }

    public static <L, R> Either<L, R> narrowK(Higher1<Higher1<\u00b5, L>, R> hkt) {
        return (Either)hkt;
    }

    public boolean isLeft();

    public boolean isRight();

    public L getLeft();

    public R getRight();

    @Override
    default public R get() {
        if (this.isRight()) {
            return this.getRight();
        }
        throw new NoSuchElementException("get() on left");
    }

    default public Option<L> left() {
        if (this.isLeft()) {
            return Option.some(this.getLeft());
        }
        return Option.none();
    }

    default public Option<R> right() {
        if (this.isRight()) {
            return Option.some(this.getRight());
        }
        return Option.none();
    }

    default public Either<R, L> swap() {
        if (this.isRight()) {
            return Either.left(this.getRight());
        }
        return Either.right(this.getLeft());
    }

    default public <T, U> Either<T, U> bimap(Function1<L, T> leftMapper, Function1<R, U> rightMapper) {
        if (this.isRight()) {
            return Either.right(rightMapper.apply(this.getRight()));
        }
        return Either.left(leftMapper.apply(this.getLeft()));
    }

    @Override
    default public <T> Either<L, T> map(Function1<R, T> map) {
        if (this.isRight()) {
            return Either.right(map.apply(this.getRight()));
        }
        return Either.left(this.getLeft());
    }

    default public <T> Either<T, R> mapLeft(Function1<L, T> map) {
        if (this.isLeft()) {
            return Either.left(map.apply(this.getLeft()));
        }
        return Either.right(this.getRight());
    }

    default public <T> Either<L, T> flatMap(Function1<R, ? extends Higher2<\u00b5, L, T>> map) {
        if (this.isRight()) {
            return map.andThen(Either::narrowK).apply(this.getRight());
        }
        return Either.left(this.getLeft());
    }

    default public <T> Either<T, R> flatMapLeft(Function1<L, ? extends Higher2<\u00b5, T, R>> map) {
        if (this.isLeft()) {
            return map.andThen(Either::narrowK).apply(this.getLeft());
        }
        return Either.right(this.getRight());
    }

    default public Option<Either<L, R>> filter(Matcher1<R> matcher) {
        if (this.isRight() && matcher.match(this.getRight())) {
            return Option.some(this);
        }
        return Option.none();
    }

    default public Either<L, R> filterOrElse(Matcher1<R> matcher, Producer<Either<L, R>> orElse) {
        if (this.isLeft() || matcher.match(this.getRight())) {
            return this;
        }
        return orElse.get();
    }

    default public R orElse(R value) {
        return this.orElse(Producer.unit(value));
    }

    default public R orElse(Producer<R> orElse) {
        if (this.isRight()) {
            return this.getRight();
        }
        return orElse.get();
    }

    default public <T> T fold(Function1<L, T> leftMapper, Function1<R, T> rightMapper) {
        if (this.isRight()) {
            return rightMapper.apply(this.getRight());
        }
        return leftMapper.apply(this.getLeft());
    }

    default public Stream<R> stream() {
        if (this.isRight()) {
            return Stream.of(this.getRight());
        }
        return Stream.empty();
    }

    default public Sequence<R> sequence() {
        if (this.isRight()) {
            return ImmutableList.of(this.get());
        }
        return ImmutableList.empty();
    }

    default public Option<R> toOption() {
        if (this.isRight()) {
            return Option.some(this.getRight());
        }
        return Option.none();
    }

    default public Validation<L, R> toValidation() {
        if (this.isRight()) {
            return Validation.valid(this.getRight());
        }
        return Validation.invalid(this.getLeft());
    }

    default public <V> Either<L, V> flatten() {
        try {
            return this.flatMap(EitherHandler.identity());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("cannot be flattened");
        }
    }

    public static <L> Monad<Higher1<\u00b5, L>> monad() {
        return new Monad<Higher1<\u00b5, L>>(){

            @Override
            public <T> Either<L, T> pure(T value) {
                return Either.right(value);
            }

            @Override
            public <T, R> Either<L, R> flatMap(Higher1<Higher1<\u00b5, L>, T> value, Function1<T, ? extends Higher1<Higher1<\u00b5, L>, R>> map) {
                return Either.narrowK(value).flatMap(map.andThen(Either::narrowK));
            }
        };
    }

    public EitherModule module();

    public static final class Right<L, R>
    implements Either<L, R> {
        private R value;

        private Right(R value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("getLeft() in right");
        }

        @Override
        public R getRight() {
            return this.value;
        }

        @Override
        public EitherModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Either::getRight)).applyTo(obj);
        }

        public String toString() {
            return "Right(" + this.value + ")";
        }
    }

    public static final class Left<L, R>
    implements Either<L, R>,
    Serializable {
        private static final long serialVersionUID = 7040154642166638129L;
        private L value;

        private Left(L value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("getRight() in left");
        }

        @Override
        public EitherModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Either::getLeft)).applyTo(obj);
        }

        public String toString() {
            return "Left(" + this.value + ")";
        }
    }

    public static final class \u00b5
    implements Kind {
    }
}

