/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.type;

import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Filterable;
import com.github.tonivade.purefun.FlatMap1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Holder;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.handler.OptionHandler;
import com.github.tonivade.purefun.type.OptionModule;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public interface Option<T>
extends FlatMap1<\u00b5, T>,
Filterable<T>,
Holder<T> {
    public static <T> Option<T> some(T value) {
        return new Some(value);
    }

    public static <T> Option<T> none() {
        return None.INSTANCE;
    }

    public static <T> Option<T> narrowK(Higher1<\u00b5, T> hkt) {
        return (Option)hkt;
    }

    public static <T> Option<T> of(Producer<T> producer) {
        T value = producer.get();
        if (Objects.nonNull(value)) {
            return Option.some(value);
        }
        return Option.none();
    }

    public static <T> Option<T> from(Optional<T> optional) {
        return optional.map(Option::some).orElseGet(Option::none);
    }

    public boolean isPresent();

    public boolean isEmpty();

    default public <R> Option<R> map(Function1<T, R> mapper) {
        if (this.isPresent()) {
            return Option.some(mapper.apply(this.get()));
        }
        return Option.none();
    }

    default public <R> Option<R> flatMap(Function1<T, ? extends Higher1<\u00b5, R>> map) {
        if (this.isPresent()) {
            return map.andThen(Option::narrowK).apply(this.get());
        }
        return Option.none();
    }

    default public Option<T> ifPresent(Consumer1<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
        return this;
    }

    default public Option<T> ifEmpty(Runnable run) {
        if (this.isEmpty()) {
            run.run();
        }
        return this;
    }

    @Override
    default public Option<T> filter(Matcher1<T> matcher) {
        if (this.isPresent() && matcher.match(this.get())) {
            return this;
        }
        return Option.none();
    }

    default public T orElse(T value) {
        return this.orElse(Producer.unit(value));
    }

    default public T orElse(Producer<T> producer) {
        if (this.isEmpty()) {
            return producer.get();
        }
        return this.get();
    }

    default public <X extends Throwable> T orElseThrow(Producer<X> producer) throws X {
        if (this.isEmpty()) {
            throw (Throwable)producer.get();
        }
        return this.get();
    }

    default public <U> U fold(Producer<U> orElse, Function1<T, U> mapper) {
        if (this.isPresent()) {
            return mapper.apply(this.get());
        }
        return orElse.get();
    }

    default public Stream<T> stream() {
        if (this.isPresent()) {
            return Stream.of(this.get());
        }
        return Stream.empty();
    }

    default public Sequence<T> sequence() {
        if (this.isPresent()) {
            return ImmutableList.of(this.get());
        }
        return ImmutableList.empty();
    }

    default public Optional<T> toOptional() {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    @Override
    default public <V> Option<V> flatten() {
        try {
            return this.flatMap((Function1)OptionHandler.identity());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("cannot be flattened");
        }
    }

    public static Monad<\u00b5> monad() {
        return new Monad<\u00b5>(){

            public <T> Option<T> pure(T value) {
                return Option.some(value);
            }

            public <T, R> Option<R> flatMap(Higher1<\u00b5, T> value, Function1<T, ? extends Higher1<\u00b5, R>> map) {
                return Option.narrowK(value).flatMap(map);
            }
        };
    }

    public OptionModule module();

    public static final class None<T>
    implements Option<T>,
    Serializable {
        private static final long serialVersionUID = 7202112931010040785L;
        private static final None<?> INSTANCE = new None();

        private None() {
        }

        @Override
        public T get() {
            throw new NoSuchElementException("get() in none");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public OptionModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return "None";
        }
    }

    public static final class Some<T>
    implements Option<T>,
    Serializable {
        private static final long serialVersionUID = 7757183287962895363L;
        private final T value;

        private Some(T value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public OptionModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Holder::get)).applyTo(obj);
        }

        public String toString() {
            return "Some(" + this.value + ")";
        }
    }

    public static final class \u00b5
    implements Kind {
    }
}

