/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.type;

import com.github.tonivade.purefun.CheckedProducer;
import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Filterable;
import com.github.tonivade.purefun.FlatMap1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Holder;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.handler.TryHandler;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.TryModule;
import com.github.tonivade.purefun.type.Validation;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;

public interface Try<T>
extends FlatMap1<\u00b5, T>,
Filterable<T>,
Holder<T> {
    public static <T> Try<T> success(T value) {
        return new Success(value);
    }

    public static <T> Try<T> failure(String message) {
        return Try.failure(new Exception(message));
    }

    public static <T> Try<T> failure() {
        return Try.failure(new Exception());
    }

    public static <T> Try<T> failure(Throwable error) {
        return new Failure(error);
    }

    public static <T> Try<T> of(CheckedProducer<T> supplier) {
        try {
            return Try.success(supplier.get());
        }
        catch (Exception error) {
            return Try.failure(error);
        }
    }

    public static <T> Try<T> narrowK(Higher1<\u00b5, T> hkt) {
        return (Try)hkt;
    }

    public Throwable getCause();

    public boolean isSuccess();

    public boolean isFailure();

    default public <R> Try<R> map(Function1<T, R> mapper) {
        if (this.isSuccess()) {
            return Try.success(mapper.apply(this.get()));
        }
        return Try.failure(this.getCause());
    }

    default public <R> Try<R> flatMap(Function1<T, ? extends Higher1<\u00b5, R>> mapper) {
        if (this.isSuccess()) {
            return mapper.andThen(Try::narrowK).apply(this.get());
        }
        return Try.failure(this.getCause());
    }

    default public Try<T> onFailure(Consumer1<Throwable> consumer) {
        if (this.isFailure()) {
            consumer.accept(this.getCause());
        }
        return this;
    }

    default public Try<T> onSuccess(Consumer1<T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.get());
        }
        return this;
    }

    default public Try<T> recover(Function1<Throwable, T> mapper) {
        if (this.isFailure()) {
            return Try.of(() -> mapper.apply(this.getCause()));
        }
        return this;
    }

    default public <X extends Throwable> Try<T> recoverWith(Class<X> type, Function1<X, T> mapper) {
        Throwable cause;
        if (this.isFailure() && type.isAssignableFrom((cause = this.getCause()).getClass())) {
            return Try.of(() -> mapper.apply(this.getCause()));
        }
        return this;
    }

    @Override
    default public Try<T> filter(Matcher1<T> matcher) {
        return this.filterOrElse(matcher, () -> Try.failure(new NoSuchElementException("filtered")));
    }

    default public Try<T> filterOrElse(Matcher1<T> matcher, Producer<Try<T>> producer) {
        if (this.isFailure() || matcher.match(this.get())) {
            return this;
        }
        return producer.get();
    }

    default public <U> U fold(Function1<Throwable, U> failureMapper, Function1<T, U> successMapper) {
        if (this.isSuccess()) {
            return successMapper.apply(this.get());
        }
        return failureMapper.apply(this.getCause());
    }

    default public T orElse(T value) {
        return this.orElse(Producer.unit(value));
    }

    default public T orElse(Producer<T> producer) {
        if (this.isSuccess()) {
            return this.get();
        }
        return producer.get();
    }

    default public Stream<T> stream() {
        if (this.isSuccess()) {
            return Stream.of(this.get());
        }
        return Stream.empty();
    }

    default public Sequence<T> sequence() {
        if (this.isSuccess()) {
            return ImmutableList.of(this.get());
        }
        return ImmutableList.empty();
    }

    default public Either<Throwable, T> toEither() {
        if (this.isSuccess()) {
            return Either.right(this.get());
        }
        return Either.left(this.getCause());
    }

    default public <E> Validation<E, T> toValidation(Function1<Throwable, E> map) {
        if (this.isSuccess()) {
            return Validation.valid(this.get());
        }
        return Validation.invalid(map.apply(this.getCause()));
    }

    default public Option<T> toOption() {
        if (this.isSuccess()) {
            return Option.some(this.get());
        }
        return Option.none();
    }

    @Override
    default public <V> Try<V> flatten() {
        try {
            return this.flatMap((Function1)TryHandler.identity());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("cannot be flattened");
        }
    }

    public static Monad<\u00b5> monad() {
        return new Monad<\u00b5>(){

            public <T> Try<T> pure(T value) {
                return Try.success(value);
            }

            public <T, R> Try<R> flatMap(Higher1<\u00b5, T> value, Function1<T, ? extends Higher1<\u00b5, R>> map) {
                return Try.narrowK(value).flatMap(map);
            }
        };
    }

    public TryModule module();

    public static final class Failure<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = -8155444386075553318L;
        private final Throwable cause;

        private Failure(Throwable cause) {
            this.cause = Objects.requireNonNull(cause);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException("failure doesn't have any value");
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }

        private String getMessage() {
            return this.cause.getMessage();
        }

        private StackTraceElement[] getStackTrace() {
            return this.cause.getStackTrace();
        }

        @Override
        public TryModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.cause.getMessage(), this.cause.getStackTrace());
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Failure::getMessage)).append(Equal.comparingArray(Failure::getStackTrace)).applyTo(obj);
        }

        public String toString() {
            return "Failure(" + this.cause + ")";
        }
    }

    public static final class Success<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = -3934628369477099278L;
        private final T value;

        private Success(T value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Throwable getCause() {
            throw new NoSuchElementException("success doesn't have any cause");
        }

        @Override
        public TryModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Holder::get)).applyTo(obj);
        }

        public String toString() {
            return "Success(" + this.value + ")";
        }
    }

    public static final class \u00b5
    implements Kind {
    }
}

