/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.type;

import com.github.tonivade.purefun.FlatMap2;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Function3;
import com.github.tonivade.purefun.Function4;
import com.github.tonivade.purefun.Function5;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Holder;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.algebra.Monad;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.ValidationModule;
import com.github.tonivade.purefun.typeclasses.Equal;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;

public interface Validation<E, T>
extends Holder<T>,
FlatMap2<\u00b5, E, T> {
    public static <E, T> Validation<E, T> valid(T value) {
        return new Valid(value);
    }

    public static <E, T> Validation<E, T> invalid(E error) {
        return new Invalid(error);
    }

    public static <E, T> Validation<E, T> narrowK(Higher2<\u00b5, E, T> hkt) {
        return (Validation)hkt;
    }

    public static <E, T> Validation<E, T> narrowK(Higher1<Higher1<\u00b5, E>, T> hkt) {
        return (Validation)hkt;
    }

    public boolean isValid();

    public boolean isInvalid();

    public E getError();

    @Override
    default public <R> Validation<E, R> map(Function1<T, R> mapper) {
        if (this.isValid()) {
            return Validation.valid(mapper.apply(this.get()));
        }
        return Validation.invalid(this.getError());
    }

    default public <U> Validation<U, T> mapError(Function1<E, U> mapper) {
        if (this.isInvalid()) {
            return Validation.invalid(mapper.apply(this.getError()));
        }
        return Validation.valid(this.get());
    }

    default public <R> Validation<E, R> flatMap(Function1<T, ? extends Higher2<\u00b5, E, R>> mapper) {
        if (this.isValid()) {
            return mapper.andThen(Validation::narrowK).apply(this.get());
        }
        return Validation.invalid(this.getError());
    }

    default public Option<Validation<E, T>> filter(Matcher1<T> matcher) {
        if (this.isInvalid() || matcher.match(this.get())) {
            return Option.some(this);
        }
        return Option.none();
    }

    default public Validation<E, T> filterOrElse(Matcher1<T> matcher, Producer<Validation<E, T>> orElse) {
        if (this.isInvalid() || matcher.match(this.get())) {
            return this;
        }
        return orElse.get();
    }

    default public T orElse(T value) {
        return this.orElse(Producer.unit(value));
    }

    default public T orElse(Producer<T> orElse) {
        if (this.isValid()) {
            return this.get();
        }
        return orElse.get();
    }

    default public <U> U fold(Function1<T, U> validMap, Function1<E, U> invalidMap) {
        if (this.isValid()) {
            return validMap.apply(this.get());
        }
        return invalidMap.apply(this.getError());
    }

    default public <R> Validation<Sequence<E>, R> ap(Validation<Sequence<E>, Function1<T, R>> other) {
        if (this.isValid() && other.isValid()) {
            return Validation.valid(((Function1)other.get()).apply(this.get()));
        }
        if (this.isInvalid() && other.isInvalid()) {
            return Validation.invalid(other.getError().append(this.getError()));
        }
        if (this.isInvalid() && other.isValid()) {
            return Validation.invalid(Sequence.listOf(this.getError()));
        }
        return Validation.invalid(other.getError());
    }

    default public Either<E, T> toEither() {
        if (this.isValid()) {
            return Either.right(this.get());
        }
        return Either.left(this.getError());
    }

    default public <V> Validation<E, V> flatten() {
        try {
            return this.flatMap(Function1.identity());
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("cannot be flattened");
        }
    }

    public static <E> Monad<Higher1<\u00b5, E>> monad() {
        return new Monad<Higher1<\u00b5, E>>(){

            @Override
            public <T> Validation<E, T> pure(T value) {
                return Validation.valid(value);
            }

            @Override
            public <T, R> Validation<E, R> flatMap(Higher1<Higher1<\u00b5, E>, T> value, Function1<T, ? extends Higher1<Higher1<\u00b5, E>, R>> map) {
                return Validation.narrowK(value).flatMap(map.andThen(Validation::narrowK));
            }
        };
    }

    public ValidationModule module();

    public static <E, T1, T2, R> Validation<Sequence<E>, R> map2(Validation<E, T1> validation1, Validation<E, T2> validation2, Function2<T1, T2, R> mapper) {
        return validation2.ap(validation1.ap(Validation.valid(mapper.curried())));
    }

    public static <E, T1, T2, T3, R> Validation<Sequence<E>, R> map3(Validation<E, T1> validation1, Validation<E, T2> validation2, Validation<E, T3> validation3, Function3<T1, T2, T3, R> mapper) {
        return validation3.ap(Validation.map2(validation1, validation2, (t1, t2) -> mapper.curried().apply(t1).apply(t2)));
    }

    public static <E, T1, T2, T3, T4, R> Validation<Sequence<E>, R> map4(Validation<E, T1> validation1, Validation<E, T2> validation2, Validation<E, T3> validation3, Validation<E, T4> validation4, Function4<T1, T2, T3, T4, R> mapper) {
        return validation4.ap(Validation.map3(validation1, validation2, validation3, (t1, t2, t3) -> mapper.curried().apply(t1).apply(t2).apply(t3)));
    }

    public static <E, T1, T2, T3, T4, T5, R> Validation<Sequence<E>, R> map5(Validation<E, T1> validation1, Validation<E, T2> validation2, Validation<E, T3> validation3, Validation<E, T4> validation4, Validation<E, T5> validation5, Function5<T1, T2, T3, T4, T5, R> mapper) {
        return validation5.ap(Validation.map4(validation1, validation2, validation3, validation4, (t1, t2, t3, t4) -> mapper.curried().apply(t1).apply(t2).apply(t3).apply(t4)));
    }

    public static final class Invalid<E, T>
    implements Validation<E, T>,
    Serializable {
        private static final long serialVersionUID = -5116403366555721062L;
        private final E error;

        private Invalid(E error) {
            this.error = Objects.requireNonNull(error);
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean isInvalid() {
            return true;
        }

        @Override
        public T get() {
            throw new NoSuchElementException("invalid value");
        }

        @Override
        public E getError() {
            return this.error;
        }

        @Override
        public ValidationModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.error);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Invalid::getError)).applyTo(obj);
        }

        public String toString() {
            return "Invalid(" + this.error + ")";
        }
    }

    public static final class Valid<E, T>
    implements Validation<E, T>,
    Serializable {
        private static final long serialVersionUID = -4276395187736455243L;
        private final T value;

        private Valid(T value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean isInvalid() {
            return false;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public E getError() {
            throw new NoSuchElementException("valid value");
        }

        @Override
        public ValidationModule module() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            return Equal.of(this).append(Equal.comparing(Valid::get)).applyTo(obj);
        }

        public String toString() {
            return "Valid(" + this.value + ")";
        }
    }

    public static final class \u00b5
    implements Kind {
    }
}

