/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.typeclasses;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class Equal<T> {
    private final T target;
    private final List<Tester<T>> testers = new LinkedList<Tester<T>>();

    private Equal(T target) {
        this.target = Objects.requireNonNull(target);
    }

    public Equal<T> append(Tester<T> tester) {
        this.testers.add(Objects.requireNonNull(tester));
        return this;
    }

    public boolean applyTo(Object obj) {
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.sameObjects(obj)) {
            return true;
        }
        return this.sameClasses(obj) && this.areEquals(obj);
    }

    private boolean areEquals(T other) {
        return this.testers.stream().allMatch(tester -> (Boolean)tester.apply(this.target, other));
    }

    private boolean sameClasses(Object obj) {
        return this.target.getClass() == obj.getClass();
    }

    private boolean sameObjects(Object obj) {
        return this.target == obj;
    }

    public static <T> Equal<T> of(T target) {
        return new Equal<T>(target);
    }

    public static <T, V> Tester<T> comparing(Function1<T, V> getter) {
        return (a, b) -> Objects.equals(getter.apply(a), getter.apply(b));
    }

    public static <T, V> Tester<T> comparingArray(Function1<T, V[]> getter) {
        return (a, b) -> Arrays.deepEquals((Object[])getter.apply(a), (Object[])getter.apply(b));
    }

    @FunctionalInterface
    public static interface Tester<T>
    extends Function2<T, T, Boolean> {
    }
}

