/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purejson.Json;
import com.github.tonivade.purejson.JsonAdapterBuilder;
import com.github.tonivade.purejson.JsonDecoder;
import com.github.tonivade.purejson.JsonEncoder;
import com.github.tonivade.purejson.JsonNode;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public interface JsonAdapter<T>
extends JsonEncoder<T>,
JsonDecoder<T> {
    public static final JsonAdapter<String> STRING = JsonAdapter.adapter(String.class);
    public static final JsonAdapter<Character> CHAR = JsonAdapter.adapter(Character.class);
    public static final JsonAdapter<Byte> BYTE = JsonAdapter.adapter(Byte.class);
    public static final JsonAdapter<Short> SHORT = JsonAdapter.adapter(Short.class);
    public static final JsonAdapter<Integer> INTEGER = JsonAdapter.adapter(Integer.class);
    public static final JsonAdapter<Long> LONG = JsonAdapter.adapter(Long.class);
    public static final JsonAdapter<BigDecimal> BIG_DECIMAL = JsonAdapter.adapter(BigDecimal.class);
    public static final JsonAdapter<BigInteger> BIG_INTEGER = JsonAdapter.adapter(BigInteger.class);
    public static final JsonAdapter<Float> FLOAT = JsonAdapter.adapter(Float.class);
    public static final JsonAdapter<Double> DOUBLE = JsonAdapter.adapter(Double.class);
    public static final JsonAdapter<Boolean> BOOLEAN = JsonAdapter.adapter(Boolean.class);

    public static <T> JsonAdapterBuilder<T> builder(Class<T> target) {
        return new JsonAdapterBuilder<T>(target);
    }

    @SafeVarargs
    public static <T> JsonAdapter<T> adapter(T ... reified) {
        if (reified.length > 0) {
            throw new IllegalArgumentException("do not pass arguments to this function, it's just a trick to get refied types");
        }
        return JsonAdapter.adapter(reified.getClass().getComponentType());
    }

    public static <T> JsonAdapter<T> adapter(Class<T> type) {
        return JsonAdapter.adapter(type);
    }

    public static <T> JsonAdapter<T> adapter(Type type) {
        return (JsonAdapter)JsonAdapter.load(type).getOrElse(() -> JsonAdapter.of(JsonEncoder.encoder(type), JsonDecoder.decoder(type)));
    }

    public static <T> Option<JsonAdapter<T>> load(Type type) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isAnnotationPresent(Json.class)) {
            return Option.of(() -> clazz.getAnnotation(Json.class).value()).filterNot(Matcher1.is(Void.class)).toTry().recover(error -> Class.forName(type.getTypeName() + "Adapter")).filter(Class::isEnum).map(c -> c.getEnumConstants()[0]).map(e -> (JsonAdapter)e).map(JsonAdapter::nullSafe).toOption();
        }
        return Option.none();
    }

    public static <T> JsonAdapter<T> of(final JsonEncoder<T> encoder, final JsonDecoder<T> decoder) {
        return new JsonAdapter<T>(){

            @Override
            public JsonNode encode(T value) {
                return encoder.encode(value);
            }

            @Override
            @Nullable
            public T decode(JsonNode json) {
                return decoder.decode(json);
            }
        };
    }

    public static <E> JsonAdapter<Iterable<E>> iterableAdapter(JsonAdapter<E> itemAdapter) {
        return JsonAdapter.of(JsonEncoder.iterableEncoder(itemAdapter), JsonDecoder.iterableDecoder(itemAdapter));
    }

    public static <V> JsonAdapter<Map<String, V>> mapAdapter(JsonAdapter<V> valueAdapter) {
        return JsonAdapter.of(JsonEncoder.mapEncoder(valueAdapter), JsonDecoder.mapDecoder(valueAdapter));
    }

    public static <T> JsonAdapter<T> nullSafe(JsonAdapter<T> adapter) {
        return JsonAdapter.of(JsonEncoder.nullSafe(adapter), JsonDecoder.nullSafe(adapter));
    }
}

