/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purejson.JsonAdapter;
import com.github.tonivade.purejson.JsonDecoder;
import com.github.tonivade.purejson.JsonEncoder;
import com.github.tonivade.purejson.JsonNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonAdapterBuilder<T> {
    private final Map<String, JsonEncoder<T>> encoders = new LinkedHashMap<String, JsonEncoder<T>>();
    private final Map<String, JsonDecoder<?>> decoders = new LinkedHashMap();
    private final Class<T> type;

    public JsonAdapterBuilder(Class<T> type) {
        this.type = (Class)Precondition.checkNonNull(type);
    }

    public JsonAdapterBuilder<T> addInteger(String name, Function1<T, Integer> accessor) {
        return this.add(name, accessor, JsonAdapter.INTEGER);
    }

    public JsonAdapterBuilder<T> addLong(String name, Function1<T, Long> accessor) {
        return this.add(name, accessor, JsonAdapter.LONG);
    }

    public JsonAdapterBuilder<T> addFloat(String name, Function1<T, Float> accessor) {
        return this.add(name, accessor, JsonAdapter.FLOAT);
    }

    public JsonAdapterBuilder<T> addDouble(String name, Function1<T, Double> accessor) {
        return this.add(name, accessor, JsonAdapter.DOUBLE);
    }

    public JsonAdapterBuilder<T> addBoolean(String name, Function1<T, Boolean> accessor) {
        return this.add(name, accessor, JsonAdapter.BOOLEAN);
    }

    public JsonAdapterBuilder<T> addString(String name, Function1<T, String> accessor) {
        return this.add(name, accessor, JsonAdapter.STRING);
    }

    public <R> JsonAdapterBuilder<T> addObject(String name, Function1<T, R> accessor, JsonAdapter<R> other) {
        return this.add(name, accessor, other);
    }

    public <R> JsonAdapterBuilder<T> addIterable(String name, Function1<T, Iterable<R>> accessor, JsonAdapter<R> other) {
        return this.add(name, accessor, JsonAdapter.iterableAdapter(other));
    }

    public JsonAdapter<T> build() {
        Constructor constructor1 = (Constructor)Sequence.listOf((Object[])this.type.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == this.decoders.size()).head().getOrElseThrow();
        return JsonAdapter.of(value -> {
            JsonNode.JsonObject object = new JsonNode.JsonObject();
            for (Map.Entry<String, JsonEncoder<T>> entry : this.encoders.entrySet()) {
                object.add(entry.getKey(), entry.getValue().encode(value));
            }
            return object;
        }, json -> {
            if (json instanceof JsonNode.JsonObject) {
                JsonNode.JsonObject o = (JsonNode.JsonObject)json;
                ArrayList params = new ArrayList();
                for (Map.Entry<String, JsonDecoder<?>> entry : this.decoders.entrySet()) {
                    JsonNode element = o.get(entry.getKey());
                    params.add(entry.getValue().decode(element));
                }
                try {
                    return constructor1.newInstance(params.toArray(Object[]::new));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IllegalArgumentException();
        });
    }

    private <R> JsonAdapterBuilder<T> add(String name, Function1<T, R> accessor, JsonAdapter<R> adapter) {
        Precondition.checkNonEmpty((String)name);
        Precondition.checkNonNull(accessor);
        Precondition.checkNonNull(adapter);
        this.encoders.put(name, adapter.compose(accessor));
        this.decoders.put(name, adapter);
        return this;
    }
}

