/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purejson.JsonAdapter;
import com.github.tonivade.purejson.JsonDSL;
import com.github.tonivade.purejson.JsonNode;
import com.github.tonivade.purejson.TypeToken;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.github.tonivade.purejson.Json"})
public class JsonAnnotationProcessor
extends AbstractProcessor {
    private static final String VALUE = "value";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.getAdapterFromAnnotation(this.getAnnotation(typeElement, element)).ifPresentOrElse(adapter -> this.adapterAlreadyExists(element, (AnnotationValue)adapter), () -> this.generateAdapter(element));
            }
        }
        return true;
    }

    private AnnotationMirror getAnnotation(TypeElement annotation, Element element) {
        return element.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().equals(annotation.asType())).findFirst().orElseThrow();
    }

    private Optional<? extends AnnotationValue> getAdapterFromAnnotation(AnnotationMirror json) {
        return json.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals(VALUE)).map(Map.Entry::getValue).findFirst();
    }

    private void adapterAlreadyExists(Element element, AnnotationValue adapter) {
        this.printNote(String.valueOf(element.getSimpleName()) + " pojo found with adapter: " + String.valueOf(adapter.getValue()));
    }

    private void generateAdapter(Element element) {
        if (element.getKind() == ElementKind.RECORD) {
            this.printNote(String.valueOf(element.getSimpleName()) + " record found");
            this.saveFile(this.modelForRecord((TypeElement)element));
        } else if (element.getKind() == ElementKind.CLASS) {
            this.printNote(String.valueOf(element.getSimpleName()) + " pojo found");
            this.saveFile(this.modelForPojo((TypeElement)element));
        } else {
            this.printError(String.valueOf(element.getSimpleName()) + " is not supported: " + String.valueOf((Object)element.getKind()));
        }
    }

    private void saveFile(Model model) {
        try {
            JavaFileObject test = this.createFile(model.packageName, model.getAdapterName());
            try (Writer openWriter = test.openWriter();){
                model.build().writeTo((Appendable)openWriter);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JavaFileObject createFile(String packageName, String className) throws IOException {
        String qualifiedName = packageName != null ? packageName + "." + className : className;
        return this.processingEnv.getFiler().createSourceFile(qualifiedName, new Element[0]);
    }

    private Model modelForPojo(TypeElement element) {
        ImmutableList fields = (ImmutableList)element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).map(VariableElement.class::cast).collect(ImmutableList.toImmutableList());
        this.findConstructor(element, fields);
        ImmutableMap methods = (ImmutableMap)element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).map(e -> Tuple.of((Object)e.getSimpleName().toString(), (Object)e)).collect(ImmutableMap.toImmutableMap(Tuple2::get1, Tuple2::get2));
        String qualifiedName = element.getQualifiedName().toString();
        String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
        String simpleName = element.getSimpleName().toString();
        return new Model(packageName, simpleName, element.asType(), (Sequence<Field>)((Sequence)fields.stream().flatMap(f -> {
            String name = f.getSimpleName().toString();
            String key = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Option accessor = methods.get((Object)key).orElse((Kind)methods.get((Object)name)).ifEmpty(() -> this.printError("not accessor found for field " + name + " of type " + String.valueOf(element.getSimpleName())));
            return accessor.map(a -> new Field(f.getSimpleName().toString(), a.getReturnType(), (ExecutableElement)a)).stream();
        }).collect(ImmutableList.toImmutableList())));
    }

    private Model modelForRecord(TypeElement element) {
        ImmutableList fields = (ImmutableList)element.getEnclosedElements().stream().filter(e -> e.getKind().name().equals("RECORD_COMPONENT")).map(RecordComponentElement.class::cast).collect(ImmutableList.toImmutableList());
        this.findConstructor(element, fields);
        String qualifiedName = element.getQualifiedName().toString();
        String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
        String simpleName = element.getSimpleName().toString();
        return new Model(packageName, simpleName, element.asType(), (Sequence<Field>)((Sequence)fields.stream().map(f -> new Field(f.getSimpleName().toString(), f.getAccessor().getReturnType(), f.getAccessor())).collect(ImmutableList.toImmutableList())));
    }

    private <T extends Element> void findConstructor(TypeElement element, ImmutableList<T> fields) {
        element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(ExecutableElement.class::cast).filter(c -> c.getParameters().size() == fields.size()).findFirst().map(Option::some).orElseGet(Option::none).ifEmpty(() -> this.printError("no proper constructor found: " + String.valueOf(element.getSimpleName()) + fields.map(Element::asType).join(",", "(", ")")));
    }

    private void printNote(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    private void printError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }

    static final class Model {
        private final String packageName;
        private final String name;
        private final TypeMirror type;
        private final Sequence<Field> fields;

        public Model(String packageName, String name, TypeMirror type, Sequence<Field> fields) {
            this.packageName = packageName;
            this.name = name;
            this.type = type;
            this.fields = fields;
        }

        String getAdapterName() {
            return this.name + "Adapter";
        }

        public JavaFile build() {
            TypeSpec typeSpec = TypeSpec.enumBuilder((String)this.getAdapterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonAdapter.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.type)})).addEnumConstant("INSTANCE").addFields(this.buildAdapters()).addMethod(MethodSpec.methodBuilder((String)"encode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)this.type), JsonAnnotationProcessor.VALUE, new Modifier[0]).returns(JsonNode.class).addCode(this.encodeMethod()).build()).addMethod(MethodSpec.methodBuilder((String)"decode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(JsonNode.class, "node", new Modifier[0]).returns(TypeName.get((TypeMirror)this.type)).addCode(this.decodeMethod()).build()).build();
            return JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).build();
        }

        private List<FieldSpec> buildAdapters() {
            ArrayList<FieldSpec> list = new ArrayList<FieldSpec>();
            for (Field field : this.fields) {
                list.add(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonAdapter.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)field.type).box()}), (String)field.getAdapterName(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.builder().add("$T.adapter($L)", new Object[]{JsonAdapter.class, field.getFieldType()}).build()).build());
            }
            return list;
        }

        private CodeBlock encodeMethod() {
            CodeBlock.Builder builder = CodeBlock.builder();
            for (Field field : this.fields) {
                builder.addStatement("var $N = $T.entry($S, $L.encode($N.$N()))", new Object[]{field.name, JsonDSL.class, field.name, field.getAdapterName(), JsonAnnotationProcessor.VALUE, field.accessor.getSimpleName()});
            }
            String params = this.fields.map(f -> f.name).join(", ");
            return builder.addStatement("return $T.object($L)", new Object[]{JsonDSL.class, params}).build();
        }

        private CodeBlock decodeMethod() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("var $N = $N.asObject()", new Object[]{"object", "node"});
            for (Field field : this.fields) {
                builder.addStatement("var $N = $L.decode($N.get($S))", new Object[]{field.name, field.getAdapterName(), "object", field.name});
            }
            String params = this.fields.map(f -> f.name).join(", ");
            return builder.addStatement("return new $N($L)", new Object[]{this.name, params}).build();
        }
    }

    static final class Field {
        private final String name;
        private final TypeMirror type;
        private final ExecutableElement accessor;

        public Field(String name, TypeMirror type, ExecutableElement accessor) {
            this.name = name;
            this.type = type;
            this.accessor = accessor;
        }

        String getAdapterName() {
            return this.name.toUpperCase() + "_ADAPTER";
        }

        CodeBlock getFieldType() {
            TypeName typeName = TypeName.get((TypeMirror)this.type);
            if (typeName.isPrimitive()) {
                return CodeBlock.builder().add("$T.class", new Object[]{typeName}).build();
            }
            if (typeName instanceof ClassName) {
                return CodeBlock.builder().add("$T.class", new Object[]{typeName}).build();
            }
            if (typeName instanceof ParameterizedTypeName) {
                return CodeBlock.builder().add("new $T<$T>(){}.getType()", new Object[]{TypeToken.class, typeName}).build();
            }
            throw new UnsupportedOperationException(typeName.toString());
        }
    }
}

