/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purejson.JsonNode;
import java.util.List;
import java.util.Map;

public final class JsonDSL {
    private JsonDSL() {
    }

    public static JsonNode array(JsonNode ... elements) {
        return JsonDSL.array(List.of(elements));
    }

    public static JsonNode array(Iterable<JsonNode> elements) {
        JsonNode.JsonArray array = new JsonNode.JsonArray();
        elements.forEach(array::add);
        return array;
    }

    public static JsonNode object(JsonNode.Tuple ... elements) {
        return JsonDSL.object(List.of(elements));
    }

    public static JsonNode object(Map<String, JsonNode> elements) {
        JsonNode.JsonObject object = new JsonNode.JsonObject();
        elements.forEach(object::add);
        return object;
    }

    public static JsonNode object(Iterable<JsonNode.Tuple> elements) {
        JsonNode.JsonObject object = new JsonNode.JsonObject();
        elements.forEach(object::add);
        return object;
    }

    public static JsonNode.Tuple entry(String name, JsonNode value) {
        return new JsonNode.Tuple(name, value);
    }

    public static JsonNode string(String value) {
        return new JsonNode.JsonString(value);
    }

    public static JsonNode number(int value) {
        return new JsonNode.JsonNumber(value);
    }

    public static JsonNode number(long value) {
        return new JsonNode.JsonNumber(value);
    }

    public static JsonNode number(float value) {
        return new JsonNode.JsonNumber(Float.valueOf(value));
    }

    public static JsonNode number(double value) {
        return new JsonNode.JsonNumber(value);
    }

    public static JsonNode bool(boolean value) {
        return value ? JsonNode.TRUE : JsonNode.FALSE;
    }
}

