/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.data.ImmutableArray;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purefun.data.ImmutableTree;
import com.github.tonivade.purefun.data.ImmutableTreeMap;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purejson.JsonAdapter;
import com.github.tonivade.purejson.JsonCreator;
import com.github.tonivade.purejson.JsonDecoderModule;
import com.github.tonivade.purejson.JsonNode;
import com.github.tonivade.purejson.JsonProperty;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface JsonDecoder<T> {
    @Nullable
    public T decode(JsonNode var1);

    default public Try<T> tryDecode(JsonNode json) {
        return Try.of(() -> this.decode(json));
    }

    default public <R> JsonDecoder<R> andThen(Function1<? super T, ? extends R> next) {
        return json -> next.apply(this.decode(json));
    }

    public static <T> JsonDecoder<T> decoder(Type type) {
        return JsonDecoder.nullSafe((JsonDecoder)JsonDecoder.load(type).getOrElse(() -> JsonDecoder.create(type)));
    }

    public static <T> Option<JsonDecoder<T>> load(Type type) {
        return JsonAdapter.load(type).map(d -> d);
    }

    public static <T> JsonDecoder<T[]> arrayDecoder(Class<T> type) {
        JsonDecoder itemDecoder = JsonDecoder.decoder(type);
        return json -> {
            if (json instanceof JsonNode.JsonArray) {
                JsonNode.JsonArray a = (JsonNode.JsonArray)json;
                Object array = Array.newInstance(type, a.size());
                for (int i = 0; i < a.size(); ++i) {
                    Array.set(array, i, itemDecoder.decode(a.get(i)));
                }
                return (Object[])array;
            }
            throw new IllegalArgumentException(json.toString());
        };
    }

    public static <T extends Enum<T>> JsonDecoder<T> enumDecoder(Class<T> type) {
        return JsonDecoder.create(String.class).andThen(string -> Enum.valueOf(type, string));
    }

    private static <T> JsonDecoder<T> recordDecoder(Class<T> clazz) {
        List<Tuple2<RecordComponent, JsonDecoder<Object>>> fields = Arrays.stream(clazz.getRecordComponents()).map(f -> Tuple2.of((Object)f, JsonDecoder.decoder(f.getGenericType()))).toList();
        List<Class> types = fields.stream().map(Tuple2::get1).map(RecordComponent::getType).toList();
        Constructor<T> constructor = JsonDecoder.findCanonicalConstructor(clazz, types);
        Function1 recordCreator = JsonDecoder.recordCreator(constructor, fields);
        return json -> {
            if (json instanceof JsonNode.JsonObject) {
                JsonNode.JsonObject object = (JsonNode.JsonObject)json;
                return recordCreator.apply((Object)object);
            }
            throw new IllegalArgumentException(json.toString());
        };
    }

    private static <T> JsonDecoder<T> pojoDecoder(Class<T> clazz) {
        List<Tuple2<Field, JsonDecoder<Object>>> fields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !f.isSynthetic()).filter(AccessibleObject::trySetAccessible).map(f -> Tuple2.of((Object)f, JsonDecoder.decoder(f.getGenericType()))).toList();
        Constructor<T> constructor = JsonDecoder.findConstructor(clazz);
        Function1 pojoCreator = JsonDecoder.pojoCreator(constructor, fields);
        return json -> {
            if (json instanceof JsonNode.JsonObject) {
                JsonNode.JsonObject object = (JsonNode.JsonObject)json;
                return pojoCreator.apply((Object)object);
            }
            throw new IllegalArgumentException(json.toString());
        };
    }

    private static <T> Function1<JsonNode.JsonObject, T> recordCreator(Constructor<T> constructor, List<Tuple2<RecordComponent, JsonDecoder<Object>>> fields) {
        return object -> {
            ArrayList values = new ArrayList();
            for (Tuple2 pair : fields) {
                JsonNode jsonElement = object.get(((RecordComponent)pair.get1()).getName());
                values.add(((JsonDecoder)pair.get2()).decode(jsonElement));
            }
            try {
                return constructor.newInstance(values.toArray(Object[]::new));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("cannot create instance of record: " + constructor.getDeclaringClass().getName(), e);
            }
        };
    }

    private static <T> Function1<JsonNode.JsonObject, T> pojoCreator(Constructor<T> constructor, List<Tuple2<Field, JsonDecoder<Object>>> fields) {
        if (!constructor.trySetAccessible()) {
            throw new IllegalStateException("cannot access to constructor: " + String.valueOf(constructor));
        }
        if (constructor.getParameterCount() > 0 && constructor.isAnnotationPresent(JsonCreator.class)) {
            return JsonDecoder.pojoCreatorFromAnnotatedConstructor(constructor, fields);
        }
        if (constructor.getParameterCount() == 0) {
            return JsonDecoder.pojoCreatorFromDefaultConstructor(constructor, fields);
        }
        throw new IllegalStateException("no suitable constructor for type " + constructor.getDeclaringClass().getName());
    }

    private static <T> Function1<JsonNode.JsonObject, T> pojoCreatorFromDefaultConstructor(Constructor<T> constructor, List<Tuple2<Field, JsonDecoder<Object>>> fields) {
        return object -> {
            try {
                Object value = constructor.newInstance(new Object[0]);
                for (Tuple2 pair : fields) {
                    JsonNode node = object.get(((Field)pair.get1()).getName());
                    ((Field)pair.get1()).set(value, ((JsonDecoder)pair.get2()).decode(node));
                }
                return value;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("cannot create pojo using constructor " + String.valueOf(constructor), e);
            }
        };
    }

    private static <T> Function1<JsonNode.JsonObject, T> pojoCreatorFromAnnotatedConstructor(Constructor<T> constructor, List<Tuple2<Field, JsonDecoder<Object>>> fields) {
        return object -> {
            try {
                Map<String, JsonDecoder> fieldsToDecode = fields.stream().collect(Collectors.toUnmodifiableMap(t -> ((Field)t.get1()).getName(), Tuple2::get2));
                Object[] values = Arrays.stream(constructor.getParameters()).map(p -> p.getAnnotation(JsonProperty.class)).map(JsonProperty::value).map(name -> fieldsToDecode.getOrDefault(name, JsonDecoderModule.NULL).decode(object.get((String)name))).toArray();
                return constructor.newInstance(values);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("cannot create pojo using constructor " + String.valueOf(constructor), e);
            }
        };
    }

    private static <T> Constructor<T> findCanonicalConstructor(Class<T> clazz, List<? extends Class<?>> types) {
        try {
            return clazz.getDeclaredConstructor((Class[])types.toArray(Class[]::new));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("cannot create instance of record: " + clazz.getName(), e);
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> type) {
        return (Constructor)JsonDecoder.findUniqueConstructor(type).or(() -> JsonDecoder.findDefaultConstructor(type)).or(() -> JsonDecoder.findAnnotatedConstructor(type)).getOrElseThrow(() -> new IllegalStateException("no suitable constructor found for type: " + type.getName()));
    }

    public static <T> Option<Constructor<?>> findUniqueConstructor(Class<T> type) {
        ImmutableList list = Sequence.listOf((Object[])type.getDeclaredConstructors());
        return list.tail().isEmpty() ? list.head() : Option.none();
    }

    public static <T> Option<Constructor<?>> findAnnotatedConstructor(Class<T> type) {
        return Sequence.listOf((Object[])type.getDeclaredConstructors()).filter(c -> c.isAnnotationPresent(JsonCreator.class)).head();
    }

    public static <T> Option<Constructor<?>> findDefaultConstructor(Class<T> type) {
        return Sequence.listOf((Object[])type.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).head();
    }

    public static <E> JsonDecoder<Iterable<E>> iterableDecoder(JsonDecoder<E> itemDecoder) {
        return json -> {
            if (json instanceof JsonNode.JsonArray) {
                JsonNode.JsonArray array = (JsonNode.JsonArray)json;
                ArrayList list = new ArrayList();
                for (JsonNode object : array) {
                    list.add(itemDecoder.decode(object));
                }
                return Collections.unmodifiableList(list);
            }
            throw new IllegalArgumentException(json.toString());
        };
    }

    public static <V> JsonDecoder<Map<String, V>> mapDecoder(JsonDecoder<V> itemEncoder) {
        return json -> {
            if (json instanceof JsonNode.JsonObject) {
                JsonNode.JsonObject object = (JsonNode.JsonObject)json;
                LinkedHashMap map = new LinkedHashMap();
                for (JsonNode.Tuple tuple : object) {
                    map.put(tuple.key(), itemEncoder.decode(tuple.value()));
                }
                return Collections.unmodifiableMap(map);
            }
            throw new IllegalArgumentException(json.toString());
        };
    }

    public static <T> JsonDecoder<T> nullSafe(JsonDecoder<T> decoder) {
        return json -> {
            if (json == null) {
                return null;
            }
            if (json instanceof JsonNode.JsonNull) {
                return null;
            }
            return decoder.decode(json);
        };
    }

    private static <T> JsonDecoder<T> create(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return JsonDecoder.create(clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return JsonDecoder.create(parameterizedType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return JsonDecoder.create(genericArrayType);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return JsonDecoder.create(wildcardType);
        }
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonDecoder<T> create(ParameterizedType type) {
        Type type2 = type.getRawType();
        if (type2 instanceof Class) {
            JsonDecoder<T> create;
            Class c = (Class)type2;
            if (Collection.class.isAssignableFrom(c)) {
                create = JsonDecoder.decoder(type.getActualTypeArguments()[0]);
                return JsonDecoder.iterableDecoder(create).andThen(JsonDecoder.toCollection(c));
            }
            if (Sequence.class.isAssignableFrom(c)) {
                create = JsonDecoder.decoder(type.getActualTypeArguments()[0]);
                return JsonDecoder.iterableDecoder(create).andThen(JsonDecoder.toSequence(c));
            }
            if (Map.class.isAssignableFrom(c) && type.getActualTypeArguments()[0].equals(String.class)) {
                create = JsonDecoder.decoder(type.getActualTypeArguments()[1]);
                return JsonDecoder.mapDecoder(create);
            }
            if (ImmutableMap.class.isAssignableFrom(c) && type.getActualTypeArguments()[0].equals(String.class)) {
                create = JsonDecoder.decoder(type.getActualTypeArguments()[1]);
                return JsonDecoder.mapDecoder(create).andThen(JsonDecoder.toImmutableMap(c));
            }
        }
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonDecoder<T> create(GenericArrayType type) {
        Type genericComponentType = type.getGenericComponentType();
        if (genericComponentType instanceof Class) {
            Class clazz = (Class)genericComponentType;
            return JsonDecoder.arrayDecoder(clazz);
        }
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonDecoder<T> create(WildcardType type) {
        throw new UnsupportedOperationException("wildcard types are not supported: " + type.getTypeName());
    }

    private static <T> JsonDecoder<T> create(Class<T> type) {
        if (type.isPrimitive()) {
            return JsonDecoder.primitiveDecoder(type);
        }
        if (type.equals(String.class)) {
            return JsonDecoderModule.STRING;
        }
        if (type.equals(Character.class)) {
            return JsonDecoderModule.CHAR;
        }
        if (type.equals(Byte.class)) {
            return JsonDecoderModule.BYTE;
        }
        if (type.equals(Short.class)) {
            return JsonDecoderModule.SHORT;
        }
        if (type.equals(Integer.class)) {
            return JsonDecoderModule.INTEGER;
        }
        if (type.equals(Long.class)) {
            return JsonDecoderModule.LONG;
        }
        if (type.equals(BigDecimal.class)) {
            return JsonDecoderModule.BIG_DECIMAL;
        }
        if (type.equals(BigInteger.class)) {
            return JsonDecoderModule.BIG_INTEGER;
        }
        if (type.equals(Float.class)) {
            return JsonDecoderModule.FLOAT;
        }
        if (type.equals(Double.class)) {
            return JsonDecoderModule.DOUBLE;
        }
        if (type.equals(Boolean.class)) {
            return JsonDecoderModule.BOOLEAN;
        }
        if (type.isEnum()) {
            return JsonDecoder.enumDecoder(type);
        }
        if (type.isArray()) {
            return JsonDecoder.arrayDecoder(type.getComponentType());
        }
        if (type.isRecord()) {
            return JsonDecoder.recordDecoder(type);
        }
        return JsonDecoder.pojoDecoder(type);
    }

    private static <T> JsonDecoder<T> primitiveDecoder(Class<T> type) {
        if (type.equals(Character.TYPE)) {
            return JsonDecoderModule.CHAR;
        }
        if (type.equals(Byte.TYPE)) {
            return JsonDecoderModule.BYTE;
        }
        if (type.equals(Short.TYPE)) {
            return JsonDecoderModule.SHORT;
        }
        if (type.equals(Integer.TYPE)) {
            return JsonDecoderModule.INTEGER;
        }
        if (type.equals(Long.TYPE)) {
            return JsonDecoderModule.LONG;
        }
        if (type.equals(Float.TYPE)) {
            return JsonDecoderModule.FLOAT;
        }
        if (type.equals(Double.TYPE)) {
            return JsonDecoderModule.DOUBLE;
        }
        if (type.equals(Boolean.TYPE)) {
            return JsonDecoderModule.BOOLEAN;
        }
        throw new IllegalArgumentException("a new primitive type?" + type.getTypeName());
    }

    private static <T> Function1<Iterable<T>, Collection<T>> toCollection(Class<?> type) {
        if (Deque.class.isAssignableFrom(type)) {
            return iterable -> ImmutableList.from((Iterable)iterable).toList();
        }
        if (Queue.class.isAssignableFrom(type)) {
            return iterable -> ImmutableList.from((Iterable)iterable).toList();
        }
        if (List.class.isAssignableFrom(type)) {
            return iterable -> ImmutableArray.from((Iterable)iterable).toList();
        }
        if (NavigableSet.class.isAssignableFrom(type)) {
            return iterable -> ImmutableTree.from((Iterable)iterable).toNavigableSet();
        }
        if (Set.class.isAssignableFrom(type)) {
            return iterable -> ImmutableSet.from((Iterable)iterable).toSet();
        }
        return iterable -> ImmutableArray.from((Iterable)iterable).toList();
    }

    private static <T> Function1<Iterable<T>, Sequence<T>> toSequence(Class<?> type) {
        if (ImmutableList.class.isAssignableFrom(type)) {
            return ImmutableList::from;
        }
        if (ImmutableArray.class.isAssignableFrom(type)) {
            return ImmutableArray::from;
        }
        if (ImmutableSet.class.isAssignableFrom(type)) {
            return ImmutableSet::from;
        }
        if (ImmutableTree.class.isAssignableFrom(type)) {
            return ImmutableTree::from;
        }
        return ImmutableList::from;
    }

    private static <T> Function1<Map<String, T>, ImmutableMap<String, T>> toImmutableMap(Class<?> type) {
        if (ImmutableTreeMap.class.isAssignableFrom(type)) {
            return ImmutableTreeMap::from;
        }
        return ImmutableMap::from;
    }
}

