/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purejson.JsonAdapter;
import com.github.tonivade.purejson.JsonEncoderModule;
import com.github.tonivade.purejson.JsonNode;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@FunctionalInterface
public interface JsonEncoder<T> {
    public JsonNode encode(T var1);

    default public Try<JsonNode> tryEncode(T value) {
        return Try.of(() -> this.encode(value));
    }

    default public <R> JsonEncoder<R> compose(Function1<? super R, ? extends T> accesor) {
        return value -> this.encode(accesor.apply(value));
    }

    public static <T> JsonEncoder<T> encoder(Type type) {
        return JsonEncoder.nullSafe((JsonEncoder)JsonEncoder.load(type).getOrElse(() -> JsonEncoder.create(type)));
    }

    public static <T> Option<JsonEncoder<T>> load(Type type) {
        return JsonAdapter.load(type).map(e -> e);
    }

    public static <T> JsonEncoder<T> arrayEncoder(Type type) {
        JsonEncoder arrayEncoder = JsonEncoder.encoder(type);
        return value -> {
            JsonNode.JsonArray array = new JsonNode.JsonArray();
            for (Object item : (Object[])value) {
                array.add(arrayEncoder.encode(item));
            }
            return array;
        };
    }

    private static <T> JsonEncoder<T> pojoEncoder(Class<T> type) {
        List<Tuple2> fields = Arrays.stream(type.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !f.isSynthetic()).filter(AccessibleObject::trySetAccessible).map(f -> Tuple2.of((Object)f, JsonEncoder.encoder(f.getGenericType()))).toList();
        return value -> {
            JsonNode.JsonObject object = new JsonNode.JsonObject();
            for (Tuple2 pair : fields) {
                try {
                    object.add(((Field)pair.get1()).getName(), ((JsonEncoder)pair.get2()).encode(((Field)pair.get1()).get(value)));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            return object;
        };
    }

    private static <T> JsonEncoder<T> recordEncoder(Class<T> record) {
        List<Tuple2> fields = Arrays.stream(record.getRecordComponents()).map(f -> Tuple2.of((Object)f, JsonEncoder.encoder(f.getGenericType()))).toList();
        return value -> {
            JsonNode.JsonObject object = new JsonNode.JsonObject();
            for (Tuple2 pair : fields) {
                try {
                    Object field = ((RecordComponent)pair.get1()).getAccessor().invoke(value, new Object[0]);
                    object.add(((RecordComponent)pair.get1()).getName(), ((JsonEncoder)pair.get2()).encode(field));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
            return object;
        };
    }

    public static <E> JsonEncoder<Iterable<E>> iterableEncoder(JsonEncoder<E> itemEncoder) {
        return value -> {
            JsonNode.JsonArray array = new JsonNode.JsonArray();
            for (Object item : value) {
                array.add(itemEncoder.encode(item));
            }
            return array;
        };
    }

    public static <V> JsonEncoder<Map<String, V>> mapEncoder(JsonEncoder<V> valueEncoder) {
        return value -> {
            JsonNode.JsonObject object = new JsonNode.JsonObject();
            for (Map.Entry entry : value.entrySet()) {
                object.add((String)entry.getKey(), valueEncoder.encode(entry.getValue()));
            }
            return object;
        };
    }

    public static <V> JsonEncoder<ImmutableMap<String, V>> immutableMapEncoder(JsonEncoder<V> valueEncoder) {
        return JsonEncoder.mapEncoder(valueEncoder).compose(ImmutableMap::toMap);
    }

    public static <T> JsonEncoder<T> nullSafe(JsonEncoder<T> encoder) {
        return value -> value == null ? JsonNode.NULL : encoder.encode(value);
    }

    private static <T> JsonEncoder<T> create(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return JsonEncoder.create(clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return JsonEncoder.create(parameterizedType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return JsonEncoder.create(genericArrayType);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return JsonEncoder.create(wildcardType);
        }
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonEncoder<T> create(ParameterizedType type) {
        Type type2 = type.getRawType();
        if (type2 instanceof Class) {
            JsonEncoder<T> create;
            Class c = (Class)type2;
            if (ImmutableMap.class.isAssignableFrom(c) && type.getActualTypeArguments()[0].equals(String.class)) {
                create = JsonEncoder.encoder(type.getActualTypeArguments()[1]);
                return JsonEncoder.immutableMapEncoder(create);
            }
            if (Map.class.isAssignableFrom(c) && type.getActualTypeArguments()[0].equals(String.class)) {
                create = JsonEncoder.encoder(type.getActualTypeArguments()[1]);
                return JsonEncoder.mapEncoder(create);
            }
            if (Iterable.class.isAssignableFrom(c)) {
                create = JsonEncoder.encoder(type.getActualTypeArguments()[0]);
                return JsonEncoder.iterableEncoder(create);
            }
        }
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonEncoder<T> create(WildcardType type) {
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonEncoder<T> create(GenericArrayType type) {
        Type genericComponentType = type.getGenericComponentType();
        if (genericComponentType instanceof Class) {
            return JsonEncoder.arrayEncoder((Class)genericComponentType);
        }
        throw new UnsupportedOperationException("not implemented yet: " + type.getTypeName());
    }

    private static <T> JsonEncoder<T> create(Class<T> type) {
        if (type.isPrimitive()) {
            return JsonEncoder.primitiveEncoder(type);
        }
        if (type.equals(String.class)) {
            return JsonEncoderModule.STRING;
        }
        if (type.equals(Character.class)) {
            return JsonEncoderModule.CHAR;
        }
        if (type.equals(Byte.class)) {
            return JsonEncoderModule.BYTE;
        }
        if (type.equals(Short.class)) {
            return JsonEncoderModule.SHORT;
        }
        if (type.equals(Integer.class)) {
            return JsonEncoderModule.INTEGER;
        }
        if (type.equals(Long.class)) {
            return JsonEncoderModule.LONG;
        }
        if (type.equals(BigDecimal.class)) {
            return JsonEncoderModule.BIG_DECIMAL;
        }
        if (type.equals(BigInteger.class)) {
            return JsonEncoderModule.BIG_INTEGER;
        }
        if (type.equals(Float.class)) {
            return JsonEncoderModule.FLOAT;
        }
        if (type.equals(Double.class)) {
            return JsonEncoderModule.DOUBLE;
        }
        if (type.equals(Boolean.class)) {
            return JsonEncoderModule.BOOLEAN;
        }
        if (type.isEnum()) {
            return JsonEncoderModule.ENUM;
        }
        if (type.isArray()) {
            return JsonEncoder.arrayEncoder(type.getComponentType());
        }
        if (type.isRecord()) {
            return JsonEncoder.recordEncoder(type);
        }
        return JsonEncoder.pojoEncoder(type);
    }

    private static <T> JsonEncoder<T> primitiveEncoder(Class<T> type) {
        if (type.equals(Character.TYPE)) {
            return JsonEncoderModule.CHAR;
        }
        if (type.equals(Byte.TYPE)) {
            return JsonEncoderModule.BYTE;
        }
        if (type.equals(Short.TYPE)) {
            return JsonEncoderModule.SHORT;
        }
        if (type.equals(Integer.TYPE)) {
            return JsonEncoderModule.INTEGER;
        }
        if (type.equals(Long.TYPE)) {
            return JsonEncoderModule.LONG;
        }
        if (type.equals(Float.TYPE)) {
            return JsonEncoderModule.FLOAT;
        }
        if (type.equals(Double.TYPE)) {
            return JsonEncoderModule.DOUBLE;
        }
        if (type.equals(Boolean.TYPE)) {
            return JsonEncoderModule.BOOLEAN;
        }
        throw new IllegalArgumentException("a new primitive? " + type.getTypeName());
    }
}

