/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purejson.JsonDSL;
import com.github.tonivade.purejson.JsonEncoder;
import java.math.BigDecimal;
import java.math.BigInteger;

interface JsonEncoderModule {
    public static final JsonEncoder<String> STRING = JsonDSL::string;
    public static final JsonEncoder<Character> CHAR = STRING.compose(Object::toString);
    public static final JsonEncoder<Byte> BYTE = JsonDSL::number;
    public static final JsonEncoder<Short> SHORT = JsonDSL::number;
    public static final JsonEncoder<Integer> INTEGER = JsonDSL::number;
    public static final JsonEncoder<Long> LONG = JsonDSL::number;
    public static final JsonEncoder<Float> FLOAT = JsonDSL::number;
    public static final JsonEncoder<Double> DOUBLE = JsonDSL::number;
    public static final JsonEncoder<Boolean> BOOLEAN = JsonDSL::bool;
    public static final JsonEncoder<Enum<?>> ENUM = STRING.compose(Enum::name);
    public static final JsonEncoder<BigDecimal> BIG_DECIMAL = DOUBLE.compose(BigDecimal::doubleValue);
    public static final JsonEncoder<BigInteger> BIG_INTEGER = LONG.compose(BigInteger::longValue);
}

