/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.type.Try;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public sealed interface JsonNode
extends Serializable {
    public static final JsonNode NULL = JsonNull.NULL;
    public static final JsonNode TRUE = JsonBoolean.TRUE;
    public static final JsonNode FALSE = JsonBoolean.TRUE;

    default public Try<Unit> writeTo(Writer writer) {
        return Try.of(() -> {
            writer.write(this.toString());
            return Unit.unit();
        });
    }

    default public boolean isArray() {
        return false;
    }

    default public boolean isObject() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isNumber() {
        return false;
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isNull() {
        return false;
    }

    default public JsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    default public JsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    default public JsonNull asNull() {
        throw new UnsupportedOperationException();
    }

    default public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    default public Number asNumber() {
        throw new UnsupportedOperationException();
    }

    default public String asString() {
        throw new UnsupportedOperationException();
    }

    default public double asDouble() {
        throw new UnsupportedOperationException();
    }

    default public float asFloat() {
        throw new UnsupportedOperationException();
    }

    default public long asLong() {
        throw new UnsupportedOperationException();
    }

    default public int asInt() {
        throw new UnsupportedOperationException();
    }

    default public byte asByte() {
        throw new UnsupportedOperationException();
    }

    default public short asShort() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public char asCharacter() {
        throw new UnsupportedOperationException();
    }

    default public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    default public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    public static enum JsonNull implements JsonNode
    {
        NULL;


        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public JsonNull asNull() {
            return this;
        }

        public String toString() {
            return "null";
        }
    }

    public static enum JsonBoolean implements JsonNode
    {
        TRUE{

            @Override
            public boolean asBoolean() {
                return true;
            }

            public String toString() {
                return "true";
            }
        }
        ,
        FALSE{

            @Override
            public boolean asBoolean() {
                return false;
            }

            public String toString() {
                return "false";
            }
        };


        @Override
        public boolean isBoolean() {
            return true;
        }
    }

    public record Tuple(String key, JsonNode value) {
        Tuple(Map.Entry<String, JsonNode> entry) {
            this(entry.getKey(), entry.getValue());
        }
    }

    public record JsonNumber(Number value) implements JsonNode
    {
        public JsonNumber {
            Precondition.checkNonNull((Object)value);
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public int asInt() {
            return this.value.intValue();
        }

        @Override
        public long asLong() {
            return this.value.longValue();
        }

        @Override
        public float asFloat() {
            return this.value.floatValue();
        }

        @Override
        public double asDouble() {
            return this.value.doubleValue();
        }

        @Override
        public short asShort() {
            return this.value.shortValue();
        }

        @Override
        public byte asByte() {
            return this.value.byteValue();
        }

        @Override
        public BigDecimal asBigDecimal() {
            return BigDecimal.valueOf(this.asDouble());
        }

        @Override
        public BigInteger asBigInteger() {
            return BigInteger.valueOf(this.asLong());
        }

        @Override
        public Number asNumber() {
            return this.value;
        }

        @Override
        public String toString() {
            String string = this.value.toString();
            if (string.endsWith(".0")) {
                return string.substring(0, string.length() - 2);
            }
            return string;
        }
    }

    public record JsonString(String value) implements JsonNode
    {
        public JsonString {
            Precondition.checkNonNull((Object)value);
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        public char asCharacter() {
            return this.asString().charAt(0);
        }

        @Override
        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    public static final class JsonObject
    implements JsonNode,
    Iterable<Tuple> {
        private static final long serialVersionUID = -5023192121266472804L;
        private final Map<String, JsonNode> values = new LinkedHashMap<String, JsonNode>();

        public JsonNode get(String name) {
            return this.values.getOrDefault(name, NULL);
        }

        @Override
        public Iterator<Tuple> iterator() {
            return this.values.entrySet().stream().map(Tuple::new).iterator();
        }

        void add(Tuple tuple) {
            this.add(tuple.key(), tuple.value());
        }

        void add(String name, JsonNode value) {
            this.values.put(name, value);
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public JsonObject asObject() {
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }

        public boolean equals(Object obj) {
            if (obj instanceof JsonObject) {
                JsonObject other = (JsonObject)obj;
                return Objects.equals(this.values, other.values);
            }
            return false;
        }

        public String toString() {
            return this.values.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\":" + String.valueOf(entry.getValue())).collect(Collectors.joining(",", "{", "}"));
        }
    }

    public static final class JsonArray
    implements JsonNode,
    Iterable<JsonNode> {
        private static final long serialVersionUID = 2330798672175039020L;
        private final List<JsonNode> values = new ArrayList<JsonNode>();

        public int size() {
            return this.values.size();
        }

        @Override
        public Iterator<JsonNode> iterator() {
            return this.values.stream().iterator();
        }

        public JsonNode get(int i) {
            return this.values.get(i);
        }

        void add(JsonNode value) {
            this.values.add(value);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public JsonArray asArray() {
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }

        public boolean equals(Object obj) {
            if (obj instanceof JsonArray) {
                JsonArray other = (JsonArray)obj;
                return Objects.equals(this.values, other.values);
            }
            return false;
        }

        public String toString() {
            return this.values.stream().map((Function<JsonNode, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/github/tonivade/purejson/JsonNode;)Ljava/lang/String;)()).collect(Collectors.joining(",", "[", "]"));
        }
    }
}

