/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.eclipsesource.json.JsonHandler;
import com.eclipsesource.json.JsonParser;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.core.Producer;
import com.github.tonivade.purefun.core.Unit;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purejson.JsonAdapter;
import com.github.tonivade.purejson.JsonNode;
import com.github.tonivade.purejson.PureJsonHandler;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;

public final class PureJson<T> {
    private final JsonAdapter<T> adapter;

    public PureJson(Type type) {
        this(JsonAdapter.adapter(type));
    }

    public PureJson(Class<T> type) {
        this(JsonAdapter.adapter(type));
    }

    @SafeVarargs
    public PureJson(T ... reified) {
        this(PureJson.getClassOf(reified));
    }

    public PureJson(JsonAdapter<T> adapter) {
        this.adapter = (JsonAdapter)Precondition.checkNonNull(adapter);
    }

    public static Try<String> serialize(JsonNode node) {
        return Try.of((Producer)(Producer)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((JsonNode)node));
    }

    public static Try<Unit> serialize(JsonNode node, Writer writer) {
        return node.writeTo(writer);
    }

    public static Try<JsonNode> parse(String json) {
        return ((Try)Option.of((Object)json).fold(Try::illegalArgumentException, Try::success)).flatMap(PureJson::tryParse);
    }

    public static Try<JsonNode> parse(Reader json) {
        return ((Try)Option.of((Object)json).fold(Try::illegalArgumentException, Try::success)).flatMap(PureJson::tryParse);
    }

    public Try<Option<T>> fromJson(String json) {
        return PureJson.parse(json).flatMap(this::fromJson);
    }

    public Try<Option<T>> fromJson(JsonNode node) {
        if (node instanceof JsonNode.JsonNull) {
            return Try.success((Object)Option.none());
        }
        return this.adapter.tryDecode(node).map(Option::some);
    }

    public Try<String> toString(T object) {
        return this.toJson(object).flatMap(PureJson::serialize);
    }

    public Try<JsonNode> toJson(T object) {
        if (object == null) {
            return Try.success((Object)JsonNode.NULL);
        }
        return this.adapter.tryEncode(object);
    }

    private static Try<JsonNode> tryParse(String json) {
        return Try.of(() -> {
            PureJsonHandler handler = new PureJsonHandler();
            new JsonParser((JsonHandler)handler).parse(json);
            return handler.getValue();
        });
    }

    private static Try<JsonNode> tryParse(Reader reader) {
        return Try.of(() -> {
            PureJsonHandler handler = new PureJsonHandler();
            new JsonParser((JsonHandler)handler).parse(reader);
            return handler.getValue();
        });
    }

    private static <T> Class<T> getClassOf(T ... reified) {
        if (reified.length > 0) {
            throw new IllegalArgumentException("do not pass arguments to this function, it's just a trick to get refied types");
        }
        return reified.getClass().getComponentType();
    }
}

