/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import com.eclipsesource.json.JsonHandler;
import com.github.tonivade.purejson.JsonNode;

class PureJsonHandler
extends JsonHandler<JsonNode.JsonArray, JsonNode.JsonObject> {
    private JsonNode value;

    PureJsonHandler() {
    }

    public JsonNode.JsonArray startArray() {
        return new JsonNode.JsonArray();
    }

    public JsonNode.JsonObject startObject() {
        return new JsonNode.JsonObject();
    }

    public void endNull() {
        this.value = JsonNode.NULL;
    }

    public void endBoolean(boolean bool) {
        this.value = bool ? JsonNode.TRUE : JsonNode.FALSE;
    }

    public void endString(String string) {
        this.value = new JsonNode.JsonString(string);
    }

    public void endNumber(String string) {
        try {
            this.value = new JsonNode.JsonNumber(Long.parseLong(string));
        }
        catch (NumberFormatException e) {
            this.value = new JsonNode.JsonNumber(Double.parseDouble(string));
        }
    }

    public void endArray(JsonNode.JsonArray array) {
        this.value = array;
    }

    public void endObject(JsonNode.JsonObject object) {
        this.value = object;
    }

    public void endArrayValue(JsonNode.JsonArray array) {
        array.add(this.value);
    }

    public void endObjectValue(JsonNode.JsonObject object, String name) {
        object.add(name, this.value);
    }

    JsonNode getValue() {
        return this.value;
    }
}

