/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purejson;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeToken<T> {
    private final Class<? super T> rawType;
    private final Type type = TypeToken.genericType(this.getClass().getGenericSuperclass());

    protected TypeToken() {
        this.rawType = TypeToken.rawType(this.type);
    }

    public Class<? super T> getRawType() {
        return this.rawType;
    }

    public Type getType() {
        return this.type;
    }

    private static Type genericType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return p.getActualTypeArguments()[0];
        }
        throw new UnsupportedOperationException("type not supported " + type.getTypeName());
    }

    private static <T> Class<? super T> rawType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return TypeToken.rawType(p.getRawType());
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            return c;
        }
        throw new UnsupportedOperationException("type not supported " + type.getTypeName());
    }
}

