/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.FutureOf;
import com.github.tonivade.purefun.concurrent.Future_;
import com.github.tonivade.purefun.concurrent.Promise;
import com.github.tonivade.purefun.instances.FutureInstances;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.zeromock.api.AsyncPostFilter;
import com.github.tonivade.zeromock.api.AsyncPreFilter;
import com.github.tonivade.zeromock.api.AsyncRequestHandler;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import java.util.Objects;

public final class AsyncHttpService {
    private final HttpServiceK<Future_> serviceK;

    public AsyncHttpService(String name) {
        this(new HttpServiceK<Future_>(name, FutureInstances.monad()));
    }

    private AsyncHttpService(HttpServiceK<Future_> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpServiceK<Future_> build() {
        return this.serviceK;
    }

    public AsyncHttpService mount(String path, AsyncHttpService other) {
        return new AsyncHttpService(this.serviceK.mount(path, other.serviceK));
    }

    public AsyncHttpService exec(AsyncRequestHandler handler) {
        return new AsyncHttpService(this.serviceK.exec(handler));
    }

    public MappingBuilder<AsyncHttpService> preFilter(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public AsyncHttpService preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(Future::success)).apply(arg_0));
    }

    public AsyncHttpService preFilter(AsyncPreFilter filter) {
        return new AsyncHttpService(this.serviceK.preFilter(filter));
    }

    public AsyncHttpService postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(Future::success)).apply(arg_0));
    }

    public AsyncHttpService postFilter(AsyncPostFilter filter) {
        return new AsyncHttpService(this.serviceK.postFilter(filter));
    }

    public MappingBuilder<AsyncHttpService> when(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addMapping).when(matcher);
    }

    public Promise<Option<HttpResponse>> execute(HttpRequest request) {
        return ((Future)this.serviceK.execute(request).fix(FutureOf::narrowK)).toPromise();
    }

    public AsyncHttpService combine(AsyncHttpService other) {
        return new AsyncHttpService(this.serviceK.combine(other.serviceK));
    }

    protected AsyncHttpService addMapping(Matcher1<HttpRequest> matcher, AsyncRequestHandler handler) {
        return new AsyncHttpService(this.serviceK.addMapping(matcher, handler));
    }

    protected AsyncHttpService addPreFilter(Matcher1<HttpRequest> matcher, AsyncRequestHandler handler) {
        return this.preFilter(arg_0 -> PreFilterK.filter(FutureInstances.monad(), matcher, handler).apply(arg_0));
    }

    public String toString() {
        return "AsyncHttpService(" + this.serviceK.name() + ")";
    }

    public static final class MappingBuilder<T> {
        private final Function2<Matcher1<HttpRequest>, AsyncRequestHandler, T> finisher;
        private Matcher1<HttpRequest> matcher;

        public MappingBuilder(Function2<Matcher1<HttpRequest>, AsyncRequestHandler, T> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
        }

        public MappingBuilder<T> when(Matcher1<HttpRequest> matcher) {
            this.matcher = matcher;
            return this;
        }

        public T then(AsyncRequestHandler handler) {
            return (T)this.finisher.apply(this.matcher, (Object)handler);
        }
    }
}

