/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Equal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class Bytes {
    private static final Equal<Bytes> EQUAL = Equal.of().append((a, b) -> Arrays.equals(a.buffer, b.buffer));
    private static final int BUFFER_SIZE = 1024;
    private static final Bytes EMPTY = new Bytes(new byte[0]);
    private final byte[] buffer;

    private Bytes(byte[] buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    public byte[] toArray() {
        byte[] copy = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, copy, 0, this.buffer.length);
        return copy;
    }

    public ByteBuffer getBuffer() {
        return ByteBuffer.wrap(this.buffer);
    }

    public int size() {
        return this.buffer.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public static Bytes empty() {
        return EMPTY;
    }

    public static Bytes fromArray(byte[] array) {
        return new Bytes(array);
    }

    public static Bytes asBytes(InputStream input) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = input.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        return new Bytes(out.toByteArray());
    }

    public static Bytes asBytes(String string) {
        return new Bytes(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String asString(Bytes buffer) {
        return new String(buffer.toArray(), StandardCharsets.UTF_8);
    }
}

