/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.data.ImmutableArray;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purefun.data.ImmutableTree;
import com.github.tonivade.purefun.data.ImmutableTreeMap;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.ImmutableArrayDeserializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableListDeserializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableMapDeserializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableSetDeserializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableTreeDeserializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableTreeMapDeserializerAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public final class Deserializers {
    private Deserializers() {
    }

    public static Function1<Bytes, JsonElement> json() {
        return Deserializers.plain().andThen(Deserializers.asJson());
    }

    public static <T> Function1<Bytes, T> xmlToObject(Class<T> clazz) {
        return bytes -> Deserializers.fromXml(bytes, clazz);
    }

    public static <T> Function1<Bytes, T> jsonToObject(Class<T> clazz) {
        return Deserializers.plain().andThen(Deserializers.fromJson(clazz));
    }

    public static <T> Function1<Bytes, T> jsonTo(Type type) {
        return Deserializers.plain().andThen(Deserializers.fromJson(type));
    }

    public static Function1<Bytes, String> plain() {
        return Bytes::asString;
    }

    private static Function1<String, JsonElement> asJson() {
        return JsonParser::parseString;
    }

    private static <T> Function1<String, T> fromJson(Type type) {
        return json -> Deserializers.fromJson(json, type);
    }

    private static Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter(ImmutableList.class, (Object)new ImmutableListDeserializerAdapter()).registerTypeAdapter(ImmutableArray.class, (Object)new ImmutableArrayDeserializerAdapter()).registerTypeAdapter(ImmutableSet.class, (Object)new ImmutableSetDeserializerAdapter()).registerTypeAdapter(ImmutableTree.class, (Object)new ImmutableTreeDeserializerAdapter()).registerTypeAdapter(ImmutableMap.class, (Object)new ImmutableMapDeserializerAdapter()).registerTypeAdapter(ImmutableTreeMap.class, (Object)new ImmutableTreeMapDeserializerAdapter()).create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T fromXml(Bytes bytes, Class<T> clazz) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes.toArray());){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)input);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private static <T> T fromJson(String json, Type type) {
        if (Objects.isNull(json) || json.isEmpty()) {
            throw new JsonSyntaxException("body cannot be null or empty");
        }
        return (T)Deserializers.buildGson().fromJson(json, type);
    }
}

