/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.RequestHandler;
import com.github.tonivade.zeromock.api.Responses;

public final class Handlers {
    private Handlers() {
    }

    public static RequestHandler ok() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::ok));
    }

    public static RequestHandler ok(String body) {
        return Handlers.ok(Bytes.asBytes(body));
    }

    public static RequestHandler ok(Bytes body) {
        return Handlers.ok((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler ok(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::ok)).apply(arg_0);
    }

    public static RequestHandler created(String body) {
        return Handlers.created(Bytes.asBytes(body));
    }

    public static RequestHandler created(Bytes body) {
        return Handlers.created((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler created(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::created)).apply(arg_0);
    }

    public static RequestHandler noContent() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::noContent));
    }

    public static RequestHandler forbidden() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::forbidden));
    }

    public static RequestHandler badRequest() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::badRequest));
    }

    public static RequestHandler badRequest(String body) {
        return Handlers.badRequest(Bytes.asBytes(body));
    }

    public static RequestHandler badRequest(Bytes body) {
        return Handlers.badRequest((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler badRequest(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::badRequest)).apply(arg_0);
    }

    public static RequestHandler notFound() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::notFound));
    }

    public static RequestHandler notFound(String body) {
        return Handlers.notFound(Bytes.asBytes(body));
    }

    public static RequestHandler notFound(Bytes body) {
        return Handlers.notFound((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler notFound(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::notFound)).apply(arg_0);
    }

    public static RequestHandler unauthorized() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::unauthorized));
    }

    public static RequestHandler unauthorized(String body) {
        return Handlers.unauthorized(Bytes.asBytes(body));
    }

    public static RequestHandler unauthorized(Bytes body) {
        return Handlers.unauthorized((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler unauthorized(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::unauthorized)).apply(arg_0);
    }

    public static RequestHandler error() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::error));
    }

    public static RequestHandler error(String body) {
        return Handlers.error(Bytes.asBytes(body));
    }

    public static RequestHandler error(Bytes body) {
        return Handlers.error((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler error(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::error)).apply(arg_0);
    }

    public static RequestHandler unavailable() {
        return Handlers.asFunction((Producer<HttpResponse>)((Producer)Responses::unavailable));
    }

    public static RequestHandler unavailable(String body) {
        return Handlers.unavailable(Bytes.asBytes(body));
    }

    public static RequestHandler unavailable(Bytes body) {
        return Handlers.unavailable((Function1<HttpRequest, Bytes>)((Function1)request -> body));
    }

    public static RequestHandler unavailable(Function1<HttpRequest, Bytes> handler) {
        return arg_0 -> ((Function1)handler.andThen(Responses::unavailable)).apply(arg_0);
    }

    private static RequestHandler asFunction(Producer<HttpResponse> producer) {
        return arg_0 -> ((Function1)producer.asFunction()).apply(arg_0);
    }
}

